<?php
namespace App\Http\Controllers\Api;

use Illuminate\Http\Request;
use App\Helpers\SalesforceHelper;
use App\Helpers\CommonHelper;
use App\Helpers\WpAPI;
use App\User;
use Validator;
use Hash;
use Config;
use Illuminate\Support\Facades\DB;
use App\Http\Controllers\Controller;
use Carbon\Carbon;
use Illuminate\Mail\Message;
use Illuminate\Support\Facades\Password;
use Illuminate\Support\Facades\File;
use App\Models\AccessToken;
use App\Models\LogsAPIs;
use App\Models\CheifComplainTypes;
use App\Models\UserDevices;


use Auth;
use Mail;

class UserController extends Controller
{
    /**
     * Create a new controller instance.
     *
     * @return void
     */
    public $data = array();
    public $api_log_id = 0;
    public $api_start_time = 0;
    public $current_request;
    public function __construct(Request $request)
    {
        $this->current_request = $request;
        $return = CommonHelper::contructLog($request);
        if(isset($return['api_start_time']))
        {
            $this->api_start_time = $return['api_start_time'];
        }
        if(isset($return['api_log_id']))
        {
            $this->api_start_time = $return['api_log_id'];
        }
    }
    public function startup(Request $request)
    {
        $bodyData['test_data'] = 123;

        $data["header"]["error"]    = '0';
        $data["header"]["message"]  = "StartUp Data";
        $data["header"]["expiry_timestamp"]  = CommonHelper::getApiExpiryTimeStamp();  
        $data['body']               = $bodyData;
        return CommonHelper::response($data, $this->api_log_id, $this->api_start_time);
    }

       public function login(Request $request)
    {
        $email = $request['email'];
        $password = $request['password'];
        $device_id = @$request['device_id'];
        $device_type = @$request['device_type'];
        if(!$email || !$password)
        {
            $aErrors[] = array();
            if(!$email)
            {
                $aErrors[] = "Email is required";
            }
            if(!$password)
            {
                $aErrors[] = "Password is required";
            }
            $data["header"]["error"]    = '1';
            $data["header"]["message"]  = implode('|', array_values(array_filter($aErrors)));
            return CommonHelper::response($data, $this->api_log_id, $this->api_start_time);
        }
        else
        {
            $userId = 0;
            $isValidUser = false;


            if(Auth::validate(['email' => $email, 'password' => $password])) //--> 'status' => 1
            {
                $user = User::where('email' , $email)->first();


                if($user)
                {
                    $userId = $user->id;

                    $_data['user_id'] = $userId;
                    $_data['device_id'] = $device_id;
                    $_data['device_type'] = $device_type;
                    $_data['status'] = 1;

                    UserDevices::updateOrCreate(['device_id' => $device_id, 'device_type' => $device_type], $_data);

                    $userRoles = array();
                    $userRolesObj = $user->getRoleNames();
                    foreach($userRolesObj as $userRoleName)
                    {
                        $userRoles[] = $userRoleName;
                    }
                    
                    //valid user
                    $name =  $user->first_name.' '.$user->last_name;
                    if($name)
                    {
                        $name = trim($name);
                    }
                    $company = $user->company;
                    $token = CommonHelper::getGUID();
                    $_data = array();
                    $_data['email'] = $email;
                    $_data['user_id'] = $userId;
                    $_data['token'] = $token;
                    $_accessToken = AccessToken::updateOrCreate(['id' => 0], $_data);
                    if($_accessToken)
                    {
                        if($_accessToken->id)
                        {
                            $userDetails = array();
                            $userDetails['user_id'] = $userId;
                            //$userDetails['user_type'] = $userType;
                            $userDetails['roles'] = $userRoles;
                            $userDetails['name']    = $name;
                            $userDetails['email']   = $email;
                            $photo = '';
                            if(!empty($user->photo))
                            {
                                $photo = env('APP_URL').env('USER_PHOTO_PATH').$user->photo;
                            }
                            $userDetails['token']   = $token;
                    
                            $data["header"]["error"]    = '0';
                            $data["header"]["message"]  = "Login Successful";
                            $data['body']               = $userDetails;
                            return CommonHelper::response($data, $this->api_log_id, $this->api_start_time);
                        }
                    }
                }
            }
            else
            {
                $data["header"]["error"]    = '1';
                $data["header"]["message"]  = "Please provide correct email or password";
                return CommonHelper::response($data, $this->api_log_id, $this->api_start_time);
            }
            $data["header"]["error"]    = '1';
            $data["header"]["message"]  = "Somehting went wrong!";
            return CommonHelper::response($data, $this->api_log_id, $this->api_start_time);
        }
    }

    public function editProfile(Request $request)
    {
        
        $id = $request['user_id'];
        if (User::where('id', '=', $id)->exists())
        {
           $userData = User::where('id', $id);
           $userData['name'] = $request['name'];
           $userData['first_name'] = $request['first_name'];
           $userData['last_name'] = $request['last_name'];
           $userData['office_phone'] = $request['office_phone'];
           $userData['extension'] = $request['extension'];
           $userData['mobile_no'] = $request['mobile_no'];
           $userData->save();
           return CommonHelper::response($userData, $this->api_log_id, $this->api_start_time);
        }
        else
        {
            $userData["header"]["error"]    = '1';
            $userData["header"]["message"]  = "Profile Id not exist.";
            return CommonHelper::response($userData, $this->api_log_id, $this->api_start_time);
        }

    }

    public function getProfile(Request $request)
    {
       $id = $request['user_id'];
       $userData = User::select('*')->where('id', $id)->get();
           if (User::where('id', '=', $id)->exists())
       {
            $data["header"]["error"]    = '0';
            $data["header"]["message"]  = "Success";
            $data['body']['details']    = $userData;
            return CommonHelper::response($data, $this->api_log_id, $this->api_start_time);
       }
        else
       {
            $data["header"]["error"]    = '1';
            $data["header"]["message"]  = "Profile Id not exist.";
            return CommonHelper::response($data, $this->api_log_id, $this->api_start_time);
       } 
    }

    
}