<?php

namespace App\Http\Controllers;
use Illuminate\Http\Request;
use App\Helpers\CommonHelper;
use App\User;
use App\Models\ForgotPassword;
use Auth;
use Hash;

class ResetPasswordController extends Controller
{
    public function resetPassword(Request $request, $token)
    {
        $input = $request->input();
        if($input)
        {
            $validateToken = ForgotPassword::where('token', $input['token'])->first();
            if(!empty($validateToken))
            {   
                $user = user::where('email', $input['email'])->first();
                if (!empty($user)) 
                {
                    $password = Hash::make($input['password']); 
                    $user->password = $password;
                    $user->save();

                    $validateToken->delete();

                    return redirect()->back()->with('success', 'Password has been reset successfully');
                }
                return redirect()->back()->with('error', 'Email not exists.');
            }else{
                return redirect()->back()->with('error', 'Invalid Token.');
            }
        }
        if($token)
        {
            $validateToken = ForgotPassword::where('token', $token)->first();
            $validateEmail = '';
            if(!empty($validateToken))
            {
                $validateEmail = $validateToken->email;
            }
            return view('reset', ['token' => $token, 'email' => $validateEmail]);
        }
        
        abort(404);
    }

}
