class DataTableEngine  {
    constructor () {
        this.dataTableId;
        this.ajaxSource;
        this.tableCols;
        this.debug              = false;
        this.table;
    }
};

const DataTable = new DataTableEngine;


DataTableEngine.prototype.initDataTable = function (target) 
{   
    this.dataTableId    = $(target);
    this.ajaxSource      = $(this.dataTableId).data('source');
        //let ajaxSource      = $(this.dataTableId).data('ajaxSource');
    let tableCols       = new Array();
    let dataCols        = $(this.dataTableId).data('cols').split(",");

    for (var i = 0; i < dataCols.length; i++)
    {   
        if(dataCols[i])
        {   
            tableCols.push(
            {
                sType:"html",
                sName:dataCols[i],
            })
            
        }
        else
        {   
            tableCols.push(
            {
             sType:"html",
                bSortable:false,
            })
        }
    }


    // Datatable Init
    $(this.dataTableId).DataTable( 
    {       
        "searching": false,
        "processing":true,
        "serverSide": true,
        "bLengthChange": false,
        "info":     false,
        "ajax": {
            "url": this.ajaxSource
        },
        "oLanguage": 
        {
            "sEmptyTable"   : "No Record Found",
            "sZeroRecords"  : "No Record Found"
        },

        "order": [[ 0, "ASC" ]],
        "aoColumns":tableCols
    });
    this.table  = $(this.dataTableId).DataTable();
    
}
