@extends('admin.layouts.master')
@section('content')
  <?php $success = false; ?>
    @if (\Session::has('error'))
        <div class="alert alert-danger">
            {!! \Session::get('error') !!}
        </div>
    @endif
    @if (\Session::has('success'))
    <?php $success = true; ?> 
        <div class="alert alert-success">
            {!! \Session::get('success') !!}
        </div>
    @endif

    <div class="page-content fade-in-up">
     <div class="row">
        <div class="col-md-6">
            <div class="ibox">
                <form class="form-purple" action="{{ route('admin_users_save') }}" method="post">
                    <input type="hidden" name="userId" value="{{@$userData->id}}">
                    <div class="ibox-head">
                        <div class="ibox-title">{{__('Add Users')}}</div>
                    </div>
                    <div class="ibox-body">
                         <div class="form-group mb-4">
                            <label>{{ __('Name') }}</label>
                            <input class="form-control" name="name" data-validation="required" type="text" placeholder="Neuro Dignostics" value="{{@$userData->name}}">
                        </div> 
                         <div class="form-group mb-4">
                            <label>{{ __('Email') }}</label>
                            <input class="form-control" name="email" data-validation="required email" type="email" placeholder="user@neurodignostics.com" value="{{@$userData->email}}">
                        </div> 
                         <div class="form-group mb-4">
                            <label>{{ __('Password') }}</label>
                            <input class="form-control" name="password" data-validation="required" type="password" placeholder="Password" value="{{@$userData->password}}">
                        </div> 
                        <div class="form-group mb-4">
                            <label>Select Role</label>
                            <select class="form-control form-control-air" name="roles[]" multiple="" data-validation="required">
                                @foreach($roleData as $row)
                                    {{$selected = ''}}
                                    @if($id > 0)
                                        @if(array_search($row->id, array_column($selectedRoles, 'id')) !== false)
                                            {{$selected = 'selected'}}
                                        @endif
                                    @endif
                                    <option {{$selected}} value="{{$row->id}}">{{ucfirst($row->name)}}</option>
                                @endforeach
                            </select>
                        </div>
                    </div>
                    <div class="ibox-footer">
                        <button title="Submit" class="btn btn-primary mr-2" type="submit" name="btn-submit" value="submit">{{__('Add Users')}}</button>
                        <!-- <button class="btn btn-outline-secondary" type="reset">Cancel</button> -->
                    </div>
                </form>
            </div>
        </div>
    </div>
</div>

<!-- JS FORM VALIDATION -->

<script src="//ajax.googleapis.com/ajax/libs/jquery/1.10.2/jquery.min.js"></script>
<script src="//cdnjs.cloudflare.com/ajax/libs/jquery-form-validator/2.3.26/jquery.form-validator.min.js"></script>
<script>
  $.validate({
    lang: 'en'
  });
</script>
@endsection

