<?php

namespace App\Http\Controllers;
use Illuminate\Http\Request;
use App\Helpers\CommonHelper;
use App\User;
use App\Models\ForgotPassword;
use Auth;
use Hash;
use Validator;

class ResetPasswordController extends Controller
{
    public function resetPassword(Request $request)
    {
        $input = $request->input();
        if($request->input('btn-submit'))
        {

            $rules = array('old_password' => 'required', 
                            'new_password' => 'required|min:6|required_with:confirm_password|same:confirm_password', 
                            'confirm_password' => 'required|min:6|required_with:new_password'
                        );

            $messages['old_password.required']     =  'Old Password is required';
            $messages['new_password.required']     =  'Password is required';
            $messages['confirm_password.required'] =  'Confirm Password is required';

            $validator = Validator::make($request->all(), $rules,$messages);
            if ($validator->fails()) 
            {   
                return redirect(route('change_password'))->withErrors($validator)->withInput();
            }
            // $validateToken = ForgotPassword::where('token', $input['token'])->first();
            // if(!empty($validateToken))
            // {   
                $user = Auth::user();
                // dd($user->password);
                if (Hash::check( $input['old_password'] , $user->password)) 
                    {
                        if ($input['new_password'] != $input['confirm_password']) 
                        {
                            return redirect()->back()->with('error', 'Password and Confirm password not matches !');
                        }
                        else
                        {
                            $password = Hash::make($input['confirm_password']); 
                            $user->password = $password;
                            $user->save();

                            // $validateToken->delete();

                            return redirect()->back()->with('success', 'Password has been changed successfully.');
                        }
                        // else
                        // {
                        // }
                    }
                    else
                    {
                        return redirect()->back()->with('error', 'Incorrect password !');
                    }

                // return redirect()->back()->with('error', 'Email not exists !');
            // }else{
            //     return redirect()->back()->with('error', 'Invalid Token.');
            // }
        }
        // if($token)
        // {
        //     $validateToken = ForgotPassword::where('token', $token)->first();
        //     $validateEmail = '';
        //     if(!empty($validateToken))
        //     {
        //         $validateEmail = $validateToken->email;
        //     }
        //     return view('reset', ['token' => $token, 'email' => $validateEmail]);
        // }
        
        abort(404);
    }

}
