<?php

namespace App\Http\Controllers\Auth;

use App\Http\Controllers\Controller;
use Illuminate\Foundation\Auth\AuthenticatesUsers;
use Auth;
use App\User;
use App\Helpers\CommonHelper;
use Illuminate\Http\Request;
Use Redirect;
use Spatie\Permission\Models\Role;
use Spatie\Permission\Models\Permission;
use DB;
use Spatie\Permission\Traits\HasRoles;
use Config;
class LoginController extends Controller
{
    /*
    |--------------------------------------------------------------------------
    | Login Controller
    |--------------------------------------------------------------------------
    |
    | This controller handles authenticating users for the application and
    | redirecting them to your home screen. The controller uses a trait
    | to conveniently provide its functionality to your applications.
    |
    */

    use AuthenticatesUsers;

    /**
     * Where to redirect users after login.
     *
     * @var string
     */
    protected $redirectTo = '/admin';

    /**
     * Create a new controller instance.
     *
     * @return void
     */
    public function __construct()
    {
        $this->middleware('guest')->except('logout');
    }

    public function logout(Request $request) 
    {
      Auth::logout();
      return redirect('/login');
    }

    protected function authenticated($request, $user)
    {   

        if($user->hasRole('admin')) 
        
        {
            return redirect()->intended('/admin');
        }

        elseif($user->hasRole('physician')) 
        
        {
            return redirect()->intended('/physician');
        }
        
        else
        {
             return redirect()->intended('/logout');
        }
    }

    protected function validateLogin(Request $request)
    {
      $this->validate($request, [
          'email' => 'required|string',
      ]);
       $email = $request->input('email');

      $password = $request->input('password');

      $checkLogin = DB::table('users')->where(['email'=>$email,'password'=>$password])->get();

      if(count($checkLogin) > 0) {
          echo "Login Successfull";
      }
      else {
          //LOGIN FAILED
         return redirect()->back()->with('error', 'Email or Password is wrong !');

         return redirect()->intended('/logout');

      }
    }

    protected function credentials(Request $request)
    {
        return array_merge($request->only('email', 'password'));
    }

  
}
