@extends('physician.layouts.master')
@section('content')
  <?php $success = false; ?>
    @if (\Session::has('error'))
        <div class="alert alert-danger">
            {!! \Session::get('error') !!}
        </div>
    @endif
    @if (\Session::has('success'))
    <?php $success = true; ?> 
        <div class="alert alert-success">
            {!! \Session::get('success') !!}
        </div>
    @endif
<div class="page-content fade-in-up">
    <div class="ibox">
        <div class="ibox-body">
            <h5 class="font-strong mb-4">{{__('Question Listing')}}</h5>
                <table
                    class="table table-bordered table-hover" 
                    id="questions" 
                    data-source = "{{ route('Questions_ajax') }}"
                    data-cols = ",,,"
                    data-search = "true"
                    >
                    <thead class="thead-default thead-lg">
                         <tr>
                            <th width="30%">Question</th>
                            <!-- <th width="10%">Sort Order</th> -->
                            <th width="30%">Question Options</th>
                            <th width="10%">Status</th>
                            <th width="10%">Actions</th>
                        </tr>
                    </thead>
                </table>
        </div>
    </div>
</div>

        <!-- END PAGE CONTENT-->
@endsection

@section('scripts')
<script>
    DataTable.initDataTable('#questions');
</script>
@endsection