<?php

namespace App\Http\Controllers;

use Illuminate\Http\Request;
use App\Models\Roles;
use App\Models\Clinics;
use App\Models\FormEnteries;
use DateTime;

use Auth;
use App\User;
use App\Helpers\CommonHelper;
use Illuminate\Support\Facades\Config;
use JsValidator;
use Validator;
class AdminController extends Controller
{
    /**
     * Create a new controller instance.
     *
     * @return void
     */
    public function __construct()
    {
        $this->middleware('auth');
    }

    /**
     * Show the application dashboard.
     *
     * @return \Illuminate\Contracts\Support\Renderable 
     */
    public function index()
    {   
        return view('admin.dashboard');
    }

// ADD AND EDIT PHYSICIAN AND ADMIN
    public function saveUsers(Request $request, $id=false)
    {
        $data['roleData']           = Roles::get();
        $data['clinicsData']        = Clinics::select('application_title','id')->get();
        $data['selectedRoles']      = array();
        $data['selected_clinic']    = array();
        $data['id']                 = $id;
        $data['userData']           = user::find($id);
        $data['selected_clinic_data'] = "";
        $data['heading'] = "Add New User";
        $data['pass_placeholder'] = "";
        if ($id) 
        {
          $data['heading'] = "Edit User";
          $data['pass_placeholder'] = "Enter password if you want to update the password";
          if ($data['userData']->picture) 
          {
            $data['pictureName'] = CommonHelper::getImageFolderUrlForUserImage($data['userData']->picture);
          }
        }
        else
        {
          $data['pictureName'] = "";
        }
        if ($id) 
        {
            $data['selectedRoles']      = $data['userData']->roles->pluck('id');
            foreach ($data['selectedRoles'] as $value) 
            {
                 $data['selectedRoleId'] =   $value;
            }
            if (!empty($data['userData']->clinic_id))
            {
                $data['selected_clinic'] = clinics::select('application_title','id')->where('id', $data['userData']->clinic_id)->get();
                foreach ($data['selected_clinic'] as  $value) 
                {
                  $data['selected_clinic_data'] = $value;
                }
            }
        }
        else 
        {
            $data['selectedRoleId'] =   "";
        }
        if($request->input('btn-submit'))
        { 

            $userId = $request->input('userId');

            $emailExist = "1";
            $sameNameEmail = "";
            if ($request->input('email')) 
            {
                $userEmail = $request->input('email');
                $oldUserEmailRetrieveFromDb           = user::select('email')->where('email',$userEmail)->where('id','<>',$userId)->first();
                if ($oldUserEmailRetrieveFromDb) 
                {
                   $emailExist = "";
                   $sameNameEmail = $oldUserEmailRetrieveFromDb->email;
                }
                else
                {
                   $emailExist = "1";
                   $sameNameEmail = "";
                }
            }

            if($userId)
            {
               
                $oldPasswordRetrieveFromDb           = user::select('password')->where('id',$userId)->first();
                // dd($oldPasswordRetrieveFromDb->password);
                if($request->input('password'))
                {
                    $password = bcrypt($request->get('password'));
                    $passwordValilation = 'password';
                    $validationsForPassword = 'required|min:6|required_with:confirm_password|same:confirm_password';
                    $confirmPasswordValilation = 'confirm_password';
                    $validationsForConfirmPassword = 'required|min:6|required_with:password';

                }
                else
                {
                    $password = $oldPasswordRetrieveFromDb->password;
                    $passwordValilation = '';
                    $validationsForPassword = '';
                    $confirmPasswordValilation = '';
                    $validationsForConfirmPassword = '';
                }
                $passwordRequired = "1";
            }
            else
            {
                $password = bcrypt($request->get('password'));
                $passwordValilation = 'password';
                $validationsForPassword = 'required|min:6|required_with:confirm_password|same:confirm_password';
                $confirmPasswordValilation = 'confirm_password';
                $validationsForConfirmPassword = 'required|min:6|required_with:password';
            }
            $rules = array('name' => 'required', 'email' => 'required|email','emailExist' => 'required',
                             $passwordValilation => $validationsForPassword,
                             $confirmPasswordValilation => $validationsForConfirmPassword,
                             'first_name' => 'required',
                             'last_name' => 'required',
                             'office_phone' => 'required',
                             'mobile_no' => 'required'
                        );
            $messages['name.required']            =  'Name is required';
            $messages['email.email']              =  'Please Enter valid email address';
            $messages['email.required']           =  'Email is required';
            $messages['emailExist.required']      =  'This Email is already exist please choose another one';
            $messages['password.required']        =  'Password is required';
            $messages['confirm_password.required'] =  'Confirm Password is required';
            $messages['first_name.required']      =  'First Name is required';
            $messages['last_name.required']       =  'Last Name is required';
            $messages['office_phone.required']    =  'Office Phone is required';
            // $messages['extension.required']       =  'Extension is required';
            $messages['mobile_no.required']       =  'Mobile No is required';
            $messages['office_phone.required']    =  'Office Phone is required';

            $request_all =  $request->all();
            $request_all['emailExist'] = $emailExist;
            $validator = Validator::make($request_all, $rules,$messages);
            if ($validator->fails()) 
            {   
                return redirect(route('admin_users_save',$userId))->withErrors($validator)->withInput();
            }
  
            $data['name']                             = $request->input('name');
            $data['email']                            = $request->input('email');
            $data['first_name']                       = $request->input('first_name');
            $data['last_name']                        = $request->input('last_name');
            $data['office_phone']                     = $request->input('office_phone');
            $data['extension']                        = $request->input('extension');
            $data['mobile_no']                        = $request->input('mobile_no');
            $clinic_id                                = $request->input('clinic');
            $roleId                                   = $request->input('roles');
            $data['id']                               = $request->input('userId');
            $data['password']                         = $password;
            $userRoles                                = array(); 
            
             if($request->file('picture')) 
            {
              $fileName = $_FILES['picture']['name'];
              $image = $request->file('picture'); 
              $image->move(config('constants.USER_IMAGE'), $image->getClientOriginalName());   
              $userImageUrlPath = $fileName;
              $data['picture']  = $userImageUrlPath;
            }
            else
            {
              $data['picture']                       = $request->input('oldPicture');
            }  
            foreach ($clinic_id as $value) 
            {
                $data['clinic_id'] = $value;
            }
            $user = User::updateOrCreate(
                ['id' => $data['id']],
                $data
            );
            $roleId  = $request->input('roles');
            if($data['id'])
            {
                $user = User::find($data['id']);
                $user->roles()->detach($user->role_id);
            }
            foreach ($roleId as $key => $value) 
            {
                $user->roles()->attach($value);
            }
            // DETACH ALL ROLES OF CURRENT ID

            return redirect(route('admin_users_listing'))->with('success', 'User save Successfully!');

        }
       
        return view('admin.users.form',$data);
    }


    //  SHOW PUSH USERS
    public function usersListing()
    {   
        return view('admin.users.listing');
    }

    //  CREATE DATATABLE FOR PUSH USERS
    public function usersAjax(Request $request)
    {
        $_getParams             = $_GET;
        $params                 = CommonHelper::_processDataTableRequest($_getParams);
        
        $draw                   = $params['draw'];      
        $offset                 = $params['offset'];
        $searchKeyword          = $params['search_keyword'];
        $sortColumn             = $params['sort_column'];
        $sortOrderDirection     = $params['sort_direction'];
        $recordsPerPage         = $params['records_per_page'];
        $objUsers             =  new User();

        $recordsTotal           = $objUsers->count();
        $recordsFiltered        = $recordsTotal;

        $recordsFiltered = $objUsers->count();
     
        $objUsers         = $objUsers->orderby('created_at', 'DESC')->get();
        $listData = array(); 
        //dd($objUsers);die;         
        foreach ($objUsers as $row) 
        {           
            $deletePath = route('admin_users_delete', $row->id);
            $editPath   = route('admin_users_save', $row->id);

            $tplActions  = <<<EOT
            <a title="Edit" class="la la-pencil" href="$editPath" value="edit"><i class="" aria-hidden="true"></i></a>
            <a title="Delete" class="ti-trash" onclick="return confirm('Are you sure want to delete this record?')" href="$deletePath"><i class="" aria-hidden="true"></i></a>
EOT;
            
            $tempArray  = array();
            $roles      = array();
            $userRoles  = $row->load('roles');
            foreach ($userRoles->roles as $key => $value) {
               $roles[] = $value->name;
            }
            $tempArray[]    = $row->name;
            $tempArray[]    = $row->email;
            $tempArray[]    = implode(' </br> ', $roles);
            $tempArray[]    = $tplActions;
            $listData[]     = $tempArray;
        }
        $data = array(
            "draw"            => $draw,
            "recordsTotal"    => $recordsTotal,
            "recordsFiltered" => $recordsFiltered,
            "data"            => $listData
        );
        
        return response()->json($data);
    }

    //  DELETE USERS
    public function deleteUsers($id)
    {
        if($id)
        {   
            $User   = User::find($id);
            if(!$User)
            {
                // Redirect to base
                return redirect(route('admin_users_listing'));
            }
            $User->where('id', $id)->delete();
            return redirect()->back()->with('success', 'User has been deleted successfully!');
            return redirect(route('admin_users_listing'));
        }
    }

    public function saveClinic(Request $request, $id = 12)
    {
        $data['ClinicId']        = $id;
        $data['data']            = Clinics::get();
       // $data['userData']        = Clinics::find($id);
        $data['clinicData']      = Clinics::find($id);
        $emailExist = "1";
        $sameNameEmail = "";
        if ($request->input('email_address')) 
        {
            $userEmail = $request->input('email_address');
            $oldUserEmailRetrieveFromDb           = Clinics::select('email_address')->where('email_address',$userEmail)->where('id','<>',$data['ClinicId'])->first();
            if ($oldUserEmailRetrieveFromDb) 
            {
               $emailExist = "";
               $sameNameEmail = $oldUserEmailRetrieveFromDb->email;
            }
            else
            {
               $emailExist = "1";
               $sameNameEmail = "";
            }
        }
        if ($id) 
          {
            if ($data['clinicData']->fav_icon) 
            {
              $data['fav_icon'] = pathinfo($data['clinicData']->fav_icon);
            }
          }
        else
          {
            $data['fav_icon'] = "";
          }
        if ($id) 
          {
            if ($data['clinicData']->logo) 
            {
              $data['logo'] = pathinfo($data['clinicData']->logo);
            }
          }
        else
          {
            $data['logo'] = "";
          }
        if ($request->input('btn-submit')) 
          {


            $rules = array('application_title' => 'required', 
                             'address' => 'required',
                             'email_address' => 'required|email',
                             'emailExist' => 'required',
                             'phone_no' => 'required',
                             'footer' => 'required'
                        );
            $messages['application_title.required'] =  'Application Title is required';
            $messages['address.email']              =  'Address is required';
            $messages['email_address.required']     =  'Email Address is required';
            $messages['email_address.email']        =  'Email Address is not valid';
            $messages['emailExist.required']        =  'This Email is already exist please choose another one';

            $messages['phone_no.required']          =  'Phone No is required';
            $messages['footer.required']            =  'Footer Text is required';

            $request_all =  $request->all();
            $request_all['emailExist'] =  $emailExist;

            $validator = Validator::make($request_all, $rules,$messages);
            if ($validator->fails()) 
            {   
                return redirect(route('admin_clinic_save',$data['ClinicId']))->withErrors($validator)->withInput();
            }



            $data['clinicId']          = $request->input('clinicId');
            $data['application_title'] = $request->input('application_title');
            $data['address']           = $request->input('address');
            $data['email_address']     = $request->input('email_address');
            $data['phone_no']          = $request->input('phone_no');
            $data['language']          = $request->input('language');
            $data['footer_text']       = $request->input('footer');


            if($request->file('fav_icon')) 
              {
                $rules = array('fav_icon' => 'required|image|mimes:jpg,png,jpeg,svg|max:2048');
                // $messages['fav_icon.required']         =  'fav icon is required';
                $messages['fav_icon.mimes']            =  'Invalid type of fav icon file.';
                $validator = Validator::make($request->all(), $rules,$messages);
                if ($validator->fails()) 
                {   
                    $favIconName = $_FILES['fav_icon']['name'];
                    $logoName = $_FILES['logo']['name'];
                    return redirect(route('admin_clinic_save',$data['clinicId']))->withErrors($validator)->withInput();
                }
                $fileName = $_FILES['fav_icon']['name'];
                $image = $request->file('fav_icon'); 
                $image->move(config('constants.USER_IMAGE'), $image->getClientOriginalName());   
                $userImageUrlPath = asset(config('constants.USER_IMAGE').$fileName);
                $data['fav_icon']  = $userImageUrlPath;
              }
            else
              {
                $data['fav_icon']  = $request->input('oldFavIcon');
              } 
            if($request->file('logo')) 
              {
                $rules = array('logo' => 'required|image|mimes:jpg,png,jpeg,svg|max:2048');
                // $messages['fav_icon.required']         =  'fav icon is required';
                $messages['logo.mimes']                =  'Invalid type of logo file.';
                $validator = Validator::make($request->all(), $rules,$messages);
                if ($validator->fails()) 
                {   
                    $logoName = $_FILES['logo']['name'];
                    return redirect(route('admin_clinic_save',$data['clinicId']))->withErrors($validator)->withInput();
                }
                $fileName = $_FILES['logo']['name'];
                $image = $request->file('logo'); 
                $image->move(config('constants.USER_IMAGE'), $image->getClientOriginalName());   
                $userImageUrlPath = asset(config('constants.USER_IMAGE').$fileName);
                $data['logo']  = $userImageUrlPath;
              }
            else
              {
                $data['logo']  = $request->input('oldLogo');
              } 

            // $rules = array('fav_icon' => 'required|image|mimes:jpg,png,jpeg,svg|max:2048','logo' => 'required|image|mimes:jpg,png,jpeg,svg|max:2048');
            // // $messages['fav_icon.required']         =  'fav icon is required';
            // $messages['fav_icon.mimes']            =  'Invalid type of fav icon file.';
            // // $messages['fav_icon.required']         =  'fav icon is required';
            // $messages['logo.mimes']                =  'Invalid type of logo file.';
            // $validator = Validator::make($request->all(), $rules,$messages);
            // if ($validator->fails()) 
            // {   
            //     $favIconName = $_FILES['fav_icon']['name'];
            //     $logoName = $_FILES['logo']['name'];
            //     return redirect(route('admin_clinic_save',$data['clinicId']))->withErrors($validator)->withInput();
            // }
            // foreach ($data['language'] as $value) 
            // {
            //     $data['language'] = $value;
            // }
            // $data['time_zone']         = $request->input('Time_zone');
            //  foreach ($data['time_zone'] as $value) 
            // {
            //     $data['time_zone'] = $value;
            // }
            // $data['website_align']     = $request->input('Website_align');
            // foreach ($data['website_align'] as $value) 
            // {
            //     $data['website_align'] = $value;
            // }
              Clinics::updateOrCreate(
                  ['id' => $data['clinicId']],
                  $data
              );
            return redirect(route('admin_clinic_save'))->with('success','Clinic data has been saved successfully.');
          }

        return view('admin.clinic.form',$data);
    }
}
