<?php

namespace App\Http\Middleware;

use Closure;
use Illuminate\Support\Facades\Auth;
use App\Helpers\CommonHelper;
use Illuminate\Http\Request;
use App\Models\AccessToken;
class OnlyForSurgeon
{
    /**
     * Handle an incoming request.
     *
     * @param  \Illuminate\Http\Request  $request
     * @param  \Closure  $next
     * @param  string|null  $guard
     * @return mixed
     */
    public $data = array();
    public $api_log_id = 0;
    public $api_start_time = 0;
    public $current_request;

    public function __construct(Request $request)
    {
        $this->current_request = $request;
        $return = CommonHelper::contructLog($request);
        if(isset($return['api_start_time']))
        {
            $this->api_start_time = $return['api_start_time'];
        }
        if(isset($return['api_log_id']))
        {
            $this->api_start_time = $return['api_log_id'];
        }
    }
    public function handle($request, Closure $next)
    {   
        $token = @$request['token'];
        if (!empty($token)) 
        {
          $AccessToken  = AccessToken::where('token',$token)->first();
          if (empty($AccessToken)) 
          {
            $data["header"]["error"]    = '400';
            $data["header"]["message"]  = 'Token does not match';
            return response($data)->header('Access-Control-Allow-Origin', '*');die;
          }
          else
          {
            return $next($request);
          }
        }
        else
        {
            $data["header"]["error"]    = '400';
            $data["header"]["message"]  = 'Token is required';
            return response($data)->header('Access-Control-Allow-Origin', '*');die;
        }
    }
}
