@extends('physician.layouts.master')
@section('content')
  <?php $success = false; ?> 
    @if (\Session::has('error'))
        <div class="alert alert-danger">
            {!! \Session::get('error') !!}
        </div>
    @endif
    @if (\Session::has('success'))
    <?php $success = true; ?> 
        <div class="alert alert-success">
            {!! \Session::get('success') !!}
        </div>
    @endif
     @if ($errors->any())
          <div class="alert alert-danger">
              <ul>
                  @foreach ($errors->all() as $error)
                      <li>{{ $error }}</li>
                  @endforeach
              </ul>
          </div>
    @endif
    <div class="page-content fade-in-up">
     <div class="row">
        <div class="col-md-12">
            <div class="ibox">
               @if ($image)
                    <img src="{{ \App\Helpers\CommonHelper::getImageFolderUrlForComplainType($image) }}" class="annotatable" />
                @else
                    <img src="{{asset('')}}assets/headachefront.jpg" class="annotatable" />
                @endif
            </div>
        </div>
    </div>
</div>

<!-- JS FORM VALIDATION -->

<script type="text/javascript" src="{{asset('')}}assets/js/jquery.min.js"></script>
<script type="text/javascript" src="{{asset('')}}assets/js/annotorious.min.js"></script>
<script type="text/javascript" src="{{asset('')}}assets/js/anno-polygon.min.js"></script>
<script type="text/javascript" src="{{asset('')}}assets/js/jquery.form-validator.min.js"></script>
<script>
  $.validate({
    lang: 'en'
  });
</script>
<script>
   

  function init() {
    // anno.addPlugin('PolygonSelector', { activate: true });

    // anno.setProperties({
    //      units: 'pixels',
    //      outline:'red'

    // });
   
              

 
    var imageMapping= @json($imageMapping);
    var imagePath= @json($imagePath);
    $.each(imageMapping, function (index, row) {
        $.each(row, function (i2, value) {
            var myAnnotation = {
                /** The URL of the image where the annotation should go **/
                src : imagePath+value.image_src,

                image_map_id : value.id,

                /** The annotation text **/
                text : value.label,

                /** The annotation shape **/
                shapes : [{
                    /** The shape type **/
                    type : 'rect',

                    /** The shape geometry (relative coordinates) **/
                    geometry : { x : value.coordinate_x, y: value.coordinate_y, width :value.coordinate_width, height: value.coordinate_height }
                }]
            }
            anno.addAnnotation(myAnnotation, "");
             
        });
    })
    anno.makeAnnotatable(document.getElementById('myImage'));

     anno.addHandler('onAnnotationRemoved', function(annotation) {
        imageMapping = annotation;
        
        // var coordinatesX =  imageMapping.shapes[0].geometry.x;
        // var coordinatesY =  imageMapping.shapes[0].geometry.y;
        // var coordinatesWidth =  imageMapping.shapes[0].geometry.width;
        // var coordinatesHeight =  imageMapping.shapes[0].geometry.height;
        // console.log(imageMapping);
         let data = new FormData();
         var myJSON = JSON.stringify(imageMapping);
         data.append('myJSON',  myJSON);
          $.ajax({
            url: "{{ route('image_map_delete') }}",
            data:data,
            type: "POST",
            processData: false,
            contentType: false,
              success:function(data)
            {
                
                // $('#something').html(response);
            }

        }); 

     });

    anno.addHandler('onAnnotationUpdated', function(annotation) {
        imageMapping = annotation;
        
        // var coordinatesX =  imageMapping.shapes[0].geometry.x;
        // var coordinatesY =  imageMapping.shapes[0].geometry.y;
        // var coordinatesWidth =  imageMapping.shapes[0].geometry.width;
        // var coordinatesHeight =  imageMapping.shapes[0].geometry.height;


        var imageType = @json($image_type);
         var complain_type_id = @json($complain_type_id);

         let data = new FormData();
         var myJSON = JSON.stringify(imageMapping);
         data.append('myJSON',  myJSON);
         data.append('image_type',  imageType);
         data.append('complain_type_id',  complain_type_id);
          $.ajax({
            url: "{{ route('image_map_ajax_edit') }}",
            data:data,
            type: "POST",
            processData: false,
            contentType: false,
              success:function(data)
            {
                // $('#something').html(response);
            }

        }); 

     });
    anno.addHandler('onAnnotationCreated', function(annotation) {
        // var imageMapping= @json($imageMapping);
        var myImg = document.querySelector(".annotatable");
        // console.log(myImg);
        var realWidth = myImg.naturalWidth;
        var realHeight = myImg.naturalHeight;
        // alert("Original width=" + realWidth + ", " + "Original height=" + realHeight);



        var imageMapping = [];
        imageMapping = annotation;
        console.log(imageMapping);
        // var coordinatesX =  imageMapping.shapes[0].geometry.x;
        // var coordinatesY =  imageMapping.shapes[0].geometry.y;
        // var coordinatesWidth =  imageMapping.shapes[0].geometry.width;
        // var coordinatesHeight =  imageMapping.shapes[0].geometry.height;
         var imageType = @json($image_type);
         var complain_type_id = @json($complain_type_id);
         let data = new FormData();
         var myJSON = JSON.stringify(imageMapping);
         data.append('myJSON',  myJSON);
         data.append('image_type',  imageType);
         data.append('complain_type_id',  complain_type_id);
          $.ajax({
            url: "{{ route('image_map_ajax_add') }}",
            data:data,
            type: "POST",
            processData: false,
            contentType: false,
              success:function(data)
            {
                console.log(data);

                annotation.image_map_id = data; //-->22;
            }

        });

    });
  }
  jQuery.noConflict();

jQuery(document).ready(function($) {
    // You can use the locally-scoped $ in here as an alias to jQuery.
    //$('.ibox').hide();
});
</script>

<body onload="init();">
      <img src="{{ \App\Helpers\CommonHelper::getImageFolderUrlForComplainType($image) }}" id="myImage"  style="display: none;" />
</body>
@endsection

