@extends('physician.layouts.master')
@section('content')
  <?php $success = false; ?>
    @if (\Session::has('error'))
        <div class="alert alert-danger">
            {!! \Session::get('error') !!}
        </div>
    @endif
    @if (\Session::has('success'))
    <?php $success = true; ?> 
        <div class="alert alert-success">
            {!! \Session::get('success') !!}
        </div>
    @endif
<div class="page-content fade-in-up">
    <div class="ibox">
        <div class="ibox-body">
            <h5 class="font-strong mb-4">Question Categories</h5>

               <div class="row">

                    <div class="col-md-12">                          
                        <form class="form-info form-inline1 form-search " action="javascript:;">
                            <div class="ibox-body">
                                <div class="row">
                                    <div class="col-sm-3 form-group mb-4">
                                        <label>Search</label>
                                        <input class="form-control text-search" type="text" placeholder="">
                                        
                                    </div>
                                             <div class="col-sm-3 form-group">
                                        <label>Status</label>

                                        <div class="row last-row">

                                            <div class="col-sm-6 form-group element-1" >

                                                    <select class="form-control status-search" name="status" >
                                                            <option value="">- Any -</option>
                                                            <option value="1">Active</option>
                                                            <option value="0">Inactive</option>
                                                    </select>

                                            </div>

                                            <div class="col-sm-6 form-group element-2" >
                                                <button class="btn btn-info button-search" type="button">Search</button>
                                            </div>
                                        </div>
                                         
                                    </div> 
                                </div>                                
                            </div>
                        </form>
                    </div>

               </div>
               <table
                    class="table table-bordered table-hover" 
                    id="questionsCategories" 
                    data-source = "{{ route('questions_categories_listing') }}"
                    data-cols = ",,,"
                    data-search = "false"
                    >
                    <thead class="thead-default thead-lg">
                         <tr>
                            <!-- <th width="20%">Category Id</th> -->
                            <th width="30%">Title</th>
                            <th width="30%">Sort Order</th>
                            <th width="30%">Status</th>
                            <th width="10%">Actions</th>
                        </tr>
                    </thead>
                </table>
        </div>
    </div>
</div>

        <!-- END PAGE CONTENT-->
@endsection

@section('scripts')
<script>
    DataTable.initDataTable('#questionsCategories');
    $('.button-search').click(function()
    {   
        DataTable.reDraw(); 
    });
</script>
@endsection