<?php

namespace App\Http\Controllers;
use Illuminate\Http\Request;
use App\Helpers\CommonHelper;
use App\Helpers\WpAPI;
use App\User;
use Validator;
use Hash;
use Config;
use Illuminate\Support\Facades\DB;
use App\Http\Controllers\Controller;
use Corcel\Model\Post as WordpressPost;
use Carbon\Carbon;
use Illuminate\Mail\Message;
use Illuminate\Support\Facades\Password;

use App\Helpers\SalesforceHelper;
use Illuminate\Support\Facades\File;

use App\Models\AccessToken;
use App\Models\SystemOnePlaceInterests;
use App\Models\UserSystemIds;
use App\Models\LogsAPIs;

//-->use App\Models\UserReadingList;
//-->use App\Models\UserFolderArticles;

use App\Models\UserFolders;
use App\Models\UserLibrary;

use App\Models\Matters;
use App\Models\MatterInvoices;
use App\Models\ConnectData;
use App\Models\UserMatterFavourites;

use App\Models\SystemOnePlaceEvents;
use App\Models\SystemOnePlaceEventSpeakers;
use App\Models\SystemOnePlaceEventUsers;

use Auth;
use Mail;

use App\Models\Questions;
use App\Models\QuestionOptions;
use App\Models\QuestionCategories;

class TestController extends Controller
{
    public function treeView()
    {
        $complainTypeId = 1;

        $data = array();

        $questions = Questions::where('complain_type_id', $complainTypeId)
                              ->get();

        foreach($questions as $q)
        {
            $questionOptions = $q->getQuestionOptions($q->id);

            foreach($questionOptions as $o)
            {
                if(!$q->parent_question_id)
                {
                    $q->parent_question_id = 0;
                }

                if(!$q->question_option_id)
                {
                    $q->question_option_id = 0;
                }

                $data[] = array(
                                
                                'question_id'    => $q->id,
                                'question_title' => $q->name,
                                'parent_question_id' => $q->parent_question_id,
                                'parent_question_option_id' => $q->question_option_id,
                                'option_id' => $o->id,
                                'option_text' => $o->title
                        );

            }
        }

        $data = $this->buildTree($data);


        $treeHTML = $this->buildTreeHTML($data);

        $heading = "Questions Tree View for Headache";

        return view('test.tree_view', [ 'data' => $data, 'heading' => $heading, 'tree_html' => $treeHTML ]);

    }

    function buildTree(array $elements, $parentId = 0, $optionId=0) 
    {
        $branch = array();

        foreach ($elements as $element) 
        {
            if( ($element['parent_question_id']  == $parentId) && ($element['parent_question_option_id']  == $optionId) ) 
            {
                $children = $this->buildTree($elements, $element['question_id'], $element['option_id']);
                
                if ($children)
                {
                    $element['children'] = $children;
                }

                $branch[] = $element;
            }
        }

        return $branch;
    }

    function buildTreeHTML($elements, $html='') 
    {
        $html .= '<ul>';

        foreach ($elements as $element) 
        {
            $html .= '<li class="jstree-open"><strong style="color: green;">' . @$element['question_title'] . '</strong> <span class="ti-arrow-right" style="padding: 0px 5px; color: red; font-weight: bold;"></span> <span style="color: blue;">' . @$element['option_text'] .'</span>';

            if(isset($element['children']))
            {
                $html = $this->buildTreeHTML($element['children'], $html);
            }

            $html .= '</li>';
        }

        $html .= '</ul>';

        return $html;
    }

    function treeHTML2($data, $html='')
    {
        $html .= '<ul>';

        foreach($data as $e)
        {
            $html .= '<li class="jstree-open">' . @$e['question_title'] . ' : ' . @$e['option_text'];

            if(isset($e['children']))
            {
                $html .= '<ul>';

                foreach($e['children'] as $c)
                {
                    $html .= '<li class="jstree-open">'. @$c['question_title'] . ' : ' . @$c['option_text'];

                    $html .= $this->treeHTML($e, $html);


                    $html .= '</li>';
                }

                $html .= '</ul>';
            }

            $html .= '</li>';

        }

        $html .= '</ul>';

        return $html;

    }

    function getTreeHTML()
    {
        return '<strong>i am here!</strong>';

    }

    public function treeView3()
    {
        $data = array();

        $complainTypeId = 1;
        $questions = Questions::where('complain_type_id', $complainTypeId)
                              ->where('parent_question_id', NULL)
                              ->get();

        foreach($questions as $_question)
        {
            $questionId = $_question->id;
            $questionTitle = $_question->name;

            $data[$questionId] = [ 'id' => $questionId, 'title' => $questionTitle ];

            $data['childs'] = $this->qLogic($questionId, $questionId);

        }

        echo '<pre>';
        print_r($data);
        exit;

        return view('test.tree_view', [ 'data' => $data ]);
    }


    function qLogic($startingQuestionId, $questionId=0, $data=array())
    {
        $question = new Questions;

        if(!$questionId)
        {
            $questionId = $startingQuestionId;

        }
        $questionOptions = $question->getQuestionOptions($questionId);

        //$data[$startingQuestionId]['options'] = array();

        if($questionOptions)
        {
            foreach($questionOptions as $r)
            {
                $optionId = $r->id;
                $optionQuestionId = $r->question_id;

                $data[$questionId]['options'][$r->id]['option_title'] = $r->title;

                $q2 = $question->getQuestionByParentQuestionOption($optionQuestionId, $optionId);

                if($q2)
                {
                    $data[$startingQuestionId]['options'][$r->id]['question'] = [
                                                                            'qid' => $q2->id, 
                                                                            'oid' => $optionId,
                                                                            'pqid' => $optionQuestionId,
                                                                            'title' => $q2->name
                                                                        ];


                     if(true)
                     {
                        $data[$startingQuestionId]['options'][$r->id]['question']['options'] = $this->qLogic($startingQuestionId, $q2->id, $data);

                     }
                    
                    
                }
                

            }
        }

        return $data;
    }

    function buildTree2(array $elements, $options = [
        'parent_id_column_name' => 'parent_id',
        'children_key_name' => 'children',
        'id_column_name' => 'id'], $parentId = 0)
    {
        $branch = array();
        foreach ($elements as $element) {
            if ($element[$options['parent_id_column_name']] == $parentId) {
                $children = buildTree2($elements, $options, $element[$options['id_column_name']]);
                if ($children) {
                    $element[$options['children_key_name']] = $children;
                }
                $branch[] = $element;
            }
        }
        return $branch;
    }
}
