<!DOCTYPE html>
<html lang="en">

<head>
    <meta charset="UTF-8">
    <meta http-equiv="X-UA-Compatible" content="IE=edge">
    <meta name="viewport" content="width=device-width initial-scale=1.0">
    <title>{{ __('Tamimi Signup') }}</title>
    <!-- GLOBAL MAINLY STYLES-->
    <link href="{{\App\Helpers\CommonHelper::get_asset('')}}assets/vendors/bootstrap/dist/css/bootstrap.min.css" rel="stylesheet" />
    <link href="{{\App\Helpers\CommonHelper::get_asset('')}}assets/vendors/font-awesome/css/font-awesome.min.css" rel="stylesheet" />
    <link href="{{\App\Helpers\CommonHelper::get_asset('')}}assets/vendors/line-awesome/css/line-awesome.min.css" rel="stylesheet" />
    <link href="{{\App\Helpers\CommonHelper::get_asset('')}}assets/vendors/themify-icons/css/themify-icons.css" rel="stylesheet" />
    <link href="{{\App\Helpers\CommonHelper::get_asset('')}}assets/vendors/animate.css/animate.min.css" rel="stylesheet" />
    <link href="{{\App\Helpers\CommonHelper::get_asset('')}}assets/vendors/toastr/toastr.min.css" rel="stylesheet" />
    <link href="{{\App\Helpers\CommonHelper::get_asset('')}}assets/vendors/bootstrap-select/dist/css/bootstrap-select.min.css" rel="stylesheet" />
    <!-- PLUGINS STYLES-->
    <!-- THEME STYLES-->
    <link href="{{\App\Helpers\CommonHelper::get_asset('')}}assets/css/main.min.css" rel="stylesheet" />
    <!-- PAGE LEVEL STYLES-->
    <style>
        body {
            background-repeat: no-repeat;
            background-size: cover;
            background-image: url({{\App\Helpers\CommonHelper::get_asset('')}}/assets/img/blog/19.jpeg);
        }

        .cover {
            position: absolute;
            top: 0;
            bottom: 0;
            left: 0;
            right: 0;
            background-color: rgba(117, 54, 230, .1);
        }

        .auth-head-icon {
            position: relative;
            height: 60px;
            width: 60px;
            display: inline-flex;
            align-items: center;
            justify-content: center;
            font-size: 30px;
            background: rgba(0, 0, 0, .6);
            color: #fff;
            box-shadow: 0 5px 20px #d6dee4;
            border-radius: 50%;
            z-index: 2;
        }

        .login-box {
            background: rgba(0, 0, 0, .6);
            color: rgba(255, 255, 255, .8);
        }

        .login-box .form-control {
            background-color: transparent;
            border-color: rgba(255, 255, 255, .6);
            color: #fff;
        }

        .login-box .form-control:focus {
            border-color: rgba(255, 255, 255, 1);
        }
    </style>
</head>

<body>
    <div class="cover"></div>
    <div style="max-width: 400px;margin: 100px auto 50px;">
        <div class="text-center mb-5">
            <span class="auth-head-icon"><i class="la la-user"></i></span>
        </div>
        <div class="ibox login-box">
            <form class="ibox-body" id="login-form" method="POST" action="{{ route('register') }}">
                        @csrf
                        <h4 class="font-strong text-center mb-5">{{ __('Tamimi Signup') }}</h4>
                        <div class="form-group mb-4">
                            
                            <input type="hidden" name="role" value="brand">
                                <input id="first_name" type="text" class="form-control form-control-line{{ $errors->has('first_name') ? ' is-invalid' : '' }}" name="first_name" value="{{ old('first_name') }}" required autofocus placeholder="First Name">

                                @if ($errors->has('name'))
                                    <span class="invalid-feedback" role="alert">
                                        <strong>{{ $errors->first('first_name') }}</strong>
                                    </span>
                                @endif
                        </div>
                        <div class="form-group mb-4">
                            
                                <input id="last_name" type="text" class="form-control form-control-line{{ $errors->has('last_name') ? ' is-invalid' : '' }}" name="last_name" value="{{ old('last_name') }}" required autofocus placeholder="Last Name">

                                @if ($errors->has('name'))
                                    <span class="invalid-feedback" role="alert">
                                        <strong>{{ $errors->first('last_name') }}</strong>
                                    </span>
                                @endif
                        </div>

                        <div class="form-group mb-4">

                                <input id="email" type="email" class="form-control form-control-line{{ $errors->has('email') ? ' is-invalid' : '' }}" name="email" value="{{ old('email') }}" required placeholder="Email">

                                @if ($errors->has('email'))
                                    <span class="invalid-feedback" role="alert">
                                        <strong>{{ $errors->first('email') }}</strong>
                                    </span>
                                @endif
                        </div>

                        <div class="form-group mb-4">
                            

                                <input id="password" type="password" class="form-control form-control-line{{ $errors->has('password') ? ' is-invalid' : '' }}" name="password" required placeholder="Password">

                                @if ($errors->has('password'))
                                    <span class="invalid-feedback" role="alert">
                                        <strong>{{ $errors->first('password') }}</strong>
                                    </span>
                                @endif
                        </div>

                        <div class="form-group mb-4">
                            

                                <input id="password-confirm" type="password" class="form-control form-control-line" name="password_confirmation" required placeholder="Confirm Password">
                        </div>

                        <div class="text-center mb-4">
                                <button type="submit" class="btn btn-primary btn-rounded btn-block">
                                    {{ __('SIGNUP') }}
                                </button>
                        </div>
                        <div class="flexbox mb-5" >
                            <a href="{{ route('login')}}">{{ __('Login') }}</a>
                        </div>
                    </form>
            </form>
        </div>
    </div>
    <!-- BEGIN PAGA BACKDROPS-->
    <div class="sidenav-backdrop backdrop"></div>
    <div class="preloader-backdrop">
        <div class="page-preloader">{{ __('Loading') }}</div>
    </div>
    <!-- CORE PLUGINS-->
    <script src="{{\App\Helpers\CommonHelper::get_asset('')}}assets/vendors/jquery/dist/jquery.min.js"></script>
    <script src="{{\App\Helpers\CommonHelper::get_asset('')}}assets/vendors/popper.js/dist/umd/popper.min.js"></script>
    <script src="{{\App\Helpers\CommonHelper::get_asset('')}}assets/vendors/bootstrap/dist/js/bootstrap.min.js"></script>
    <script src="{{\App\Helpers\CommonHelper::get_asset('')}}assets/vendors/metisMenu/dist/metisMenu.min.js"></script>
    <script src="{{\App\Helpers\CommonHelper::get_asset('')}}assets/vendors/jquery-slimscroll/jquery.slimscroll.min.js"></script>
    <script src="{{\App\Helpers\CommonHelper::get_asset('')}}assets/vendors/jquery-idletimer/dist/idle-timer.min.js"></script>
    <script src="{{\App\Helpers\CommonHelper::get_asset('')}}assets/vendors/toastr/toastr.min.js"></script>
    <script src="{{\App\Helpers\CommonHelper::get_asset('')}}assets/vendors/jquery-validation/dist/jquery.validate.min.js"></script>
    <script src="{{\App\Helpers\CommonHelper::get_asset('')}}assets/vendors/bootstrap-select/dist/js/bootstrap-select.min.js"></script>
    <!-- PAGE LEVEL PLUGINS-->
    <!-- CORE SCRIPTS-->
    <script src="{{\App\Helpers\CommonHelper::get_asset('')}}assets/js/app.min.js"></script>
    <!-- PAGE LEVEL SCRIPTS-->
    <script>
        $(function() {
            $('#login-form').validate({
                errorClass: "help-block",
                rules: {
                    email: {
                        required: true,
                        email: true
                    },
                    password: {
                        required: true
                    }
                },
                highlight: function(e) {
                    $(e).closest(".form-group").addClass("has-error")
                },
                unhighlight: function(e) {
                    $(e).closest(".form-group").removeClass("has-error")
                },
            });
        });
    </script>
</body>

</html>