<?php

namespace App\Http\Middleware;

use Closure;
use Illuminate\Support\Facades\Auth;

class OnlyForAdmin
{
    /**
     * Handle an incoming request.
     *
     * @param  \Illuminate\Http\Request  $request
     * @param  \Closure  $next
     * @param  string|null  $guard
     * @return mixed
     */
  
    public function handle($request, Closure $next)
    {
        // Get the current route.
        $user = Auth::User();

        if($user)
        {
            if($user->hasRole('admin')) 
            {
                return $next($request);
            }
        }
        return response('Unauthorized.', 401);
    }
}
