<?php

namespace App\Http\Middleware;

use Closure;
use Illuminate\Support\Facades\Auth;

class RedirectIfAuthenticated
{
    /**
     * Handle an incoming request.
     *
     * @param  \Illuminate\Http\Request  $request
     * @param  \Closure  $next
     * @param  string|null  $guard
     * @return mixed
     */
    public function handle($request, Closure $next, $guard = null)
    {
        if (Auth::guard($guard)->check()) {
            $role = "logout";
            if(Auth::user()->roles->pluck( 'name' )->first() == config('constants.ADMIN'))
            {
                $role = config('constants.ADMIN');
            }
            if(Auth::user()->roles->pluck( 'name' )->first() == config('constants.PHYSICIAN'))
            {
                $role = config('constants.PHYSICIAN');
            }
            if(Auth::user()->roles->pluck( 'name' )->first() == config('constants.SURGEON'))
            {
                $role = config('constants.SURGEON');
            }

                return redirect('/'.$role);
        }

        return $next($request);
    }
}
