<?php

namespace App\Mail;

use Illuminate\Bus\Queueable;
use Illuminate\Mail\Mailable;
use Illuminate\Queue\SerializesModels;
use Illuminate\Contracts\Queue\ShouldQueue;

class SendMailable extends Mailable
{
    use Queueable, SerializesModels;
    public $narrativeSummary;

    /**
     * Create a new message instance.
     *
     * @return void
     */
    public function __construct($narrativeSummary)
    {
        $this->narrativeSummary = $narrativeSummary;
    }

    /**
     * Build the message.
     *
     * @return $this
     */
    public function build()
    {
        $this->subject('Neuro Diagnostics');
        return $this->view('emails.user_email_confirmation', ['narrativeSummary' => $this->narrativeSummary]);
    }
}