<?php

namespace App;

use Illuminate\Notifications\Notifiable;
use Illuminate\Contracts\Auth\MustVerifyEmail;
use Illuminate\Foundation\Auth\User as Authenticatable;

use Spatie\Permission\Traits\HasRoles;

class User extends Authenticatable
{
    use Notifiable;
    use HasRoles;
    /**
     * The attributes that are mass assignable.
     *
     * @var array
     */


    protected $fillable = [
        'name','email', 'password','remember_token', 'first_name','last_name','office_phone','extension','mobile_no','picture','clinic_id'
    ];

    /**
     * The attributes that should be hidden for arrays.
     *
     * @var array
     */
    protected $hidden = [
        'password', 'remember_token',
    ];

    public function bank_details()
    {
        return $this->hasOne('App\Model\BankDetails');
    }

    public function user_interests()
    {
        return $this->hasMany('App\Model\UserInterests');
    }

    public function UserSocialNetwork()
    {
        return $this->hasMany('App\Model\UserSocialNetwork');
    }

    public static function validateUser($email)
    {
        $user = DB::table('users')->select('users.*')
        ->where(DB::raw('LOWER(email)'), strtolower($email))
        ->get();   
        
        if(count($user) > 0)
        {
            return $user;
        }
        else
        {
            return false;
        }
    }

    public function signupEmployee($email, $info=array())
    {
        $first_name = @$info['first_name'];
        $last_name  = @$info['last_name'];

        $user = $this->where('email' , $email)->first();

        $defaultPassword = 'click123';

        if($user) //user already found with this email!
        {
            if(!$user->hasRole(config('api.roles.employee')))
            {
                $user->assignRole(config('api.roles.employee'));
            }
        }
        else
        {
            $user = User::create([

              'first_name'  => $first_name,
              'last_name'   => $last_name,
              'email'       => $email,
              'password'    => Hash::make($defaultPassword),
          ]);

          if($user)
          {
            $userId = $user->id;

            if($userId)
            {
              $user->assignRole(config('api.roles.employee'));
            }
          }
        }
    }
}
