class DataTableEngine  {
    constructor () {
        this.dataTableId;
        this.ajaxSource;
        this.tableCols;
        this.debug              = false;
        this.search             = false;
        this.table;
        this.status             = false;    
    }
};

const DataTable = new DataTableEngine;


DataTableEngine.prototype.initDataTable = function (target) 
{   
    this.dataTableId    = $(target);
    this.ajaxSource      = $(this.dataTableId).data('source');
        //let ajaxSource      = $(this.dataTableId).data('ajaxSource');
    let tableCols       = new Array();
    let dataCols        = $(this.dataTableId).data('cols').split(",");

    for (var i = 0; i < dataCols.length; i++)
    {   
        if(dataCols[i])
        {   
            tableCols.push(
            {
                sType:"html",
                sName:dataCols[i],
            })
            
        }
        else
        {   
            tableCols.push(
            {
             sType:"html",
                bSortable:false,
            })
        }
    }

    if($(this.dataTableId).data('search')==true)
    {
        this.search             = true;
    }

    
    // Datatable Init
    $(this.dataTableId).DataTable( 
    {   
        "searching": this.search,
        "processing":true,
        "serverSide": true,
        "bLengthChange": false,
        "info":     false,
        "ajax": {
            "url": this.ajaxSource,
             "data": function ( d ) {
                d.search_keyword     = $('.text-search').val(),
                d.complain   = $('.complain-search').val(),
                d.category   = $('.category-search').val(),
                d.status     = $('.status-search').val();
            }

        },
        "oLanguage": 
        {
            "sEmptyTable"   : "No Record Found",
            "sZeroRecords"  : "No Record Found"
        },

        "order": [[ 0, "ASC" ]],
        "aoColumns":tableCols
    });


    this.table  = $(this.dataTableId).DataTable();
    

}
DataTableEngine.prototype.reDraw = function (target) 
{   
    var loadTable = this.table
    loadTable.draw();  
}