annotorious.plugin.PolygonSelector=function(config_opts){if(config_opts)this._activate=config_opts.activate};annotorious.plugin.PolygonSelector.prototype.onInitAnnotator=function(annotator){annotator.addSelector(new annotorious.plugin.PolygonSelector.Selector);if(this._activate)annotator.setCurrentSelector("polygon")};annotorious.plugin.PolygonSelector.Selector=function(){};annotorious.plugin.PolygonSelector.Selector.prototype.init=function(annotator,canvas){this._annotator=annotator;this._canvas=canvas;this._g2d=canvas.getContext("2d");this._anchor;this._points=[];this._mouse;this._enabled=false;this._mouseMoveListener;this._mouseUpListener};annotorious.plugin.PolygonSelector.Selector.prototype._attachListeners=function(){var self=this;var refresh=function(last,highlight_last){self._g2d.clearRect(0,0,self._canvas.width,self._canvas.height);self._g2d.lineWidth=2.5;self._g2d.strokeStyle="#000000";self._g2d.beginPath();self._g2d.moveTo(self._anchor.x,self._anchor.y);for(var i=0;i<self._points.length;i++){self._g2d.lineTo(self._points[i].x,self._points[i].y)}self._g2d.lineTo(last.x,last.y);self._g2d.stroke();self._g2d.lineWidth=1.4;self._g2d.strokeStyle="#ffffff";self._g2d.beginPath();self._g2d.moveTo(self._anchor.x,self._anchor.y);for(var i=0;i<self._points.length;i++){self._g2d.lineTo(self._points[i].x,self._points[i].y)}self._g2d.lineTo(last.x,last.y);self._g2d.stroke();if(highlight_last){self._g2d.lineWidth=1;self._g2d.fillStyle="#ffffff";self._g2d.strokeStyle="#000000";self._g2d.beginPath();self._g2d.arc(last.x,last.y,3.5,0,2*Math.PI,false);self._g2d.fill();self._g2d.stroke()}};var isClosable=function(x,y){return self._points.length>1&&Math.abs(x-self._anchor.x)<5&&Math.abs(y-self._anchor.y)<5};this._mouseMoveListener=this._canvas.addEventListener("mousemove",function(event){if(self._enabled){if(event.offsetX==undefined){event.offsetX=event.layerX;event.offsetY=event.layerY}self._mouse={x:event.offsetX,y:event.offsetY};refresh(self._mouse,isClosable(event.offsetX,event.offsetY))}});this._mouseUpListener=this._canvas.addEventListener("mouseup",function(event){if(event.offsetX==undefined){event.offsetX=event.layerX;event.offsetY=event.layerY}if(isClosable(event.offsetX,event.offsetY)){self._enabled=false;refresh(self._anchor);self._annotator.fireEvent("onSelectionCompleted",{mouseEvent:event,shape:self.getShape(),viewportBounds:self.getViewportBounds()})}else{self._points.push({x:event.offsetX,y:event.offsetY})}})};annotorious.plugin.PolygonSelector.Selector.prototype._detachListeners=function(){if(this._mouseMoveListener){delete this._mouseMoveListener}if(this._mouseUpListener){delete this._mouseUpListener}};annotorious.plugin.PolygonSelector.Selector.prototype.getName=function(){return"polygon"};annotorious.plugin.PolygonSelector.Selector.prototype.getSupportedShapeType=function(){return"polygon"};annotorious.plugin.PolygonSelector.Selector.prototype.startSelection=function(x,y){this._enabled=true;this._attachListeners();this._anchor={x:x,y:y};this._annotator.fireEvent("onSelectionStarted",{offsetX:x,offsetY:y})};annotorious.plugin.PolygonSelector.Selector.prototype.stopSelection=function(){this._detachListeners();this._g2d.clearRect(0,0,this._canvas.width,this._canvas.height);this._points=[]};annotorious.plugin.PolygonSelector.Selector.prototype.getShape=function(){var points=[];points.push(this._annotator.toItemCoordinates(this._anchor));var self=this;for(var i=0;i<this._points.length;i++){points.push(self._annotator.toItemCoordinates(this._points[i]))}return{type:"polygon",geometry:{points:points}}};annotorious.plugin.PolygonSelector.Selector.prototype.getViewportBounds=function(){var right=this._anchor.x;var left=this._anchor.x;var top=this._anchor.y;var bottom=this._anchor.y;for(var i=0;i<this._points.length;i++){var pt=this._points[i];if(pt.x>right)right=pt.x;if(pt.x<left)left=pt.x;if(pt.y>bottom)bottom=pt.y;if(pt.y<top)top=pt.y}return{top:top,right:right,bottom:bottom,left:left}};annotorious.plugin.PolygonSelector.Selector.prototype.drawShape=function(g2d,shape,highlight){var color;if(highlight){color="#fff000"}else{color="#ffffff"}g2d.lineWidth=1.3;g2d.strokeStyle="#000000";var outline=annotorious.geometry.expand(shape,1.2).geometry.points;g2d.beginPath();g2d.moveTo(outline[0].x,outline[0].y);for(var i=1;i<outline.length;i++){g2d.lineTo(outline[i].x,outline[i].y)}g2d.lineTo(outline[0].x,outline[0].y);g2d.stroke();g2d.lineWidth=1.2;g2d.strokeStyle=color;var points=shape.geometry.points;g2d.beginPath();g2d.moveTo(points[0].x,points[0].y);for(var i=1;i<points.length;i++){g2d.lineTo(points[i].x,points[i].y)}g2d.lineTo(points[0].x,points[0].y);g2d.stroke()};