@extends('admin.layouts.master')
@section('content')
  <?php $success = false; ?>
    @if (\Session::has('error'))
        <div class="alert alert-danger">
            {!! \Session::get('error') !!}
        </div>
    @endif
    @if (\Session::has('success'))
    <?php $success = true; ?> 
        <div class="alert alert-success">
            {!! \Session::get('success') !!}
        </div>
    @endif
      @if ($errors->any())
          <div class="alert alert-danger">
              <ul>
                  @foreach ($errors->all() as $error)
                      <li>{{ $error }}</li>
                  @endforeach
              </ul>
          </div>
    @endif
    <div class="page-content fade-in-up">
     <div class="row">
        <div class="col-md-12">
            <div class="ibox">
                <form class="form-purple" action="{{ route('admin_clinic_save') }}" method="post" enctype="multipart/form-data">
                    <input type="hidden" name="clinicId" value="{{@$ClinicId}}">
                    <div class="ibox-head">
                        <div class="ibox-title">{{__('Clinic')}}</div>
                    </div>
                    <div class="ibox-body col-md-8">
                         <div class="form-group mb-4">
                            <label>{{ __('Application Title*') }}</label>
                            <input class="form-control" name="application_title" data-validation1="required" type="text" placeholder="Neuro Dignostics" value="{{old('application_title', @$clinicData->application_title)}}">
                        </div> 
                         <div class="form-group mb-4">
                            <label>{{ __('Address') }}</label>
                            <input class="form-control" name="address" data-validation1="required" type="text" placeholder="" value="{{old('address', @$clinicData->address)}}">
                        </div> 
                         <div class="form-group mb-4">
                            <label>{{ __('Email Address') }}</label>
                            <input class="form-control" name="email_address" data-validation1="required" type="email" placeholder="Password" value="{{old('email_address',  @$clinicData->email_address)}}">
                        </div> 
                        <div class="form-group mb-4">
                            <label>{{ __('Phone No') }}</label>
                            <input class="form-control" name="phone_no" data-validation1="required|number" type="text" placeholder="" value="{{old('phone_no', @$clinicData->phone_no)}}">
                        </div> 
                        <div class="form-group mb-4">
                            <label>{{ __('Favicon') }}</label>
                            @if(@$clinicData->fav_icon)
                             <br>
                            <img width="400px" src="{{$clinicData->fav_icon}}"><br><br>
                            @endif
                            <input type="hidden" name="oldFavIcon" value="{{@$clinicData->fav_icon}}">
                            @if(@$clinicData->fav_icon == "")
                            @php($required = 'required')
                            @else
                            @php($required = '')
                            @endif
                            <input class="form-control " name="fav_icon" data-validation="{{$required}}" type="file" placeholder="" value="{{@$clinicData->fav_icon}}">
                            <!-- @if ($errors->has('fav_icon'))
                                <span class="help-block">
                                    <strong>{{ $errors->first('fav_icon') }}</strong>
                                </span>
                            @endif -->
                        </div> 
                        <div class="form-group mb-4">
                            <label>{{ __('Logo') }}</label>
                            @if(@$clinicData->logo)
                            <br>
                            <img width="400px" src="{{$clinicData->logo}}"><br><br>
                            @endif
                            <input type="hidden" name="oldLogo" value="{{@$clinicData->logo}}">
                            @if(@$clinicData->logo == "")
                            @php($required = 'required')
                            @else
                            @php($required = '')
                            @endif
                            <input class="form-control" name="logo" data-validation="{{$required}}" type="file" placeholder="" value="{{old('logo', @$clinicData->logo)}}">
                        </div> 
                        <!-- <div class="form-group mb-4">
                            <label>{{ __('Language') }}</label>
                            <select class="form-control" name="language[]"  data-validation1="required">
                                    @foreach($data as $row)
                                        {{$selected = ''}}
                                        
                                        <option {{$selected}} value="{{$row->id}}">{{ucfirst($row->language)}}</option>
                                    @endforeach
                            </select>
                        </div> 
                            <label>{{ __('Time Zone') }}</label>
                        <div class="form-group mb-4">
                            <select class="form-control" name="Time_zone[]"  data-validation1="required">
                                      @foreach($data as $row)
                                        {{$selected = ''}}
                                        
                                        <option {{$selected}} value="{{$row->id}}">{{ucfirst($row->time_zone)}}</option>
                                    @endforeach
                            </select>
                        </div> 
                        <div class="form-group mb-4">
                            <label>{{ __('Website Align') }}</label>
                            <select class="form-control" name="Website_align[]"  data-validation1="required">
                                       @foreach($data as $row)
                                        {{$selected = ''}}
                                        
                                        <option {{$selected}} value="{{$row->id}}">{{ucfirst($row->website_align)}}</option>
                                    @endforeach
                            </select>
                        </div>  -->
                        <div class="form-group mb-4">
                            <label>{{ __('Footer Text') }}</label>
                            <input class="form-control" name="footer" data-validation1="required" type="text" placeholder="" value="{{ old('footer', @$clinicData->footer_text)}}">
                        </div>
                    </div>
                    <div class="ibox-footer">
                        <button title="Submit" class="btn btn-primary mr-2" type="submit" name="btn-submit" value="submit">{{__('Save Clinic')}}</button>
                        <!-- <button class="btn btn-outline-secondary" type="reset">Cancel</button> -->
                    </div>
                </form>
            </div>
        </div>
    </div>
</div>

<!-- JS FORM VALIDATION -->

<script src="//ajax.googleapis.com/ajax/libs/jquery/1.10.2/jquery.min.js"></script>
<script src="//cdnjs.cloudflare.com/ajax/libs/jquery-form-validator/2.3.26/jquery.form-validator.min.js"></script>
<script>
  $.validate({
    lang: 'en'
  });
</script>
@endsection

