@extends('admin.layouts.master')
@section('content')
  <?php $success = false; ?>
    @if (\Session::has('error'))
        <div class="alert alert-danger">
            {!! \Session::get('error') !!}
        </div>
    @endif
    @if (\Session::has('success'))
    <?php $success = true; ?> 
        <div class="alert alert-success">
            {!! \Session::get('success') !!}
        </div>
    @endif
        @if ($errors->any())
          <div class="alert alert-danger">
              <ul>
                  @foreach ($errors->all() as $error)
                      <li>{{ $error }}</li>
                  @endforeach
              </ul>
          </div>
    @endif
    <div class="page-content fade-in-up">
     <div class="row">
        <div class="col-md-12">
            <div class="ibox">
                <form class="form-purple" action="{{ route('admin_users_save') }}" method="post" enctype="multipart/form-data">
                    <input type="hidden" name="userId" value="{{@$userData->id}}">
                    <div class="ibox-head">
                        <div class="ibox-title">{{@$heading}}</div>
                    </div>
                    <div class="ibox-body col-md-8">
                         <div class="form-group mb-4">
                            <label>{{ __('Name') }}</label>
                            <input class="form-control" name="name" data-validation1="required" type="text" placeholder="Neuro Dignostics" value="{{ old('name', @$userData->name)}}">
                        </div> 
                         <div class="form-group mb-4">
                            <label>{{ __('Email') }}</label>
                            <input class="form-control" name="email" data-validation1="required email" type="email" placeholder="user@neurodignostics.com" value="{{ old('email',@$userData->email)}}">
                        </div> 
                        <div class="form-group mb-4">
                            <label>{{ __('Password') }}</label>
                            @if(@$userData->password)
                            @php($required = '')
                            @else
                            @php($required = 'required')
                            @endif
                            <input class="form-control" name="password" data-validation1="{{$required}}" type="password" placeholder="{{@$pass_placeholder}}" value="">
                        </div>
                        <div class="form-group mb-4">
                            <label>{{ __('Confirm Password') }}</label>
                            <input type="hidden" name="oldPassword" value="{{@$userData->password}}">
                            <input class="form-control" name="confirm_password" data-validation1="{{$required}}" type="password" placeholder="{{@$pass_placeholder}}" value="">
                        </div> 
                        <div class="form-group mb-4">
                            <label>Select Role</label>
                            <select class="form-control form-control-air" name="roles[]"  data-validation1="required">
                                @foreach($roleData as $row)
                                    {{$selected = ''}}
                                    @if(@$selectedRoleId)
                                        @if($row->id == $selectedRoleId)
                                            {{$selected = 'selected'}}
                                        @endif
                                    @endif
                                    <option {{$selected}} value="{{$row->id}}">{{ucfirst($row->name)}}</option>
                                @endforeach
                            </select>
                        </div>
                        <div class="form-group mb-4">
                            <label>{{ __('First Name') }}</label>
                            <input class="form-control" name="first_name" data-validation1="required" type="text" placeholder="" value="{{ old('first_name', @$userData->first_name)}}">
                        </div> 
                        <div class="form-group mb-4">
                            <label>{{ __('Last Name') }}</label>
                            <input class="form-control" name="last_name" data-validation1="required" type="text" placeholder="" value="{{ old('last_name', @$userData->last_name)}}">
                        </div> 
                        <div class="form-group mb-4">
                            <label>{{ __('Office Phone') }}</label>
                            <input class="form-control" name="office_phone" data-validation1="required|number" type="text" placeholder="" value="{{ old('office_phone', @$userData->office_phone)}}">
                        </div> 
                        <div class="form-group mb-4">
                            <label>{{ __('Extension') }}</label>
                            <input class="form-control" name="extension" data-validation1="required|number" type="text" placeholder="" value="{{ old('extension', @$userData->extension)}}">
                        </div> 
                        <div class="form-group mb-4">
                            <label>{{ __('Mobile No') }}</label>
                            <input class="form-control" name="mobile_no" data-validation1="required|number" type="text" placeholder="" value="{{ old('mobile_no', @$userData->mobile_no)}}">
                        </div> 
                         <div class="form-group mb-4">
                            <label>{{ __('Picture') }}</label><br>
                            @if(@$userData->picture)
                            <img src="{{@$pictureName}}" width="400px"><br><br>
                            @endif
                            <input type="hidden" name="oldPicture" value="{{@$userData->picture}}">
                            @if(@$userData->picture == "")
                            @php($required = 'required')
                            @else
                            @php($required = '')
                            @endif
                            <input class="form-control" name="picture" data-validation1="{{$required}}" type="file" placeholder="" value="">
                        </div>
                        <select class="form-control" name="clinic[]"  data-validation1="required">
                                @foreach($clinicsData as $row)
                                    {{$selected = ''}}
                                    @if($selected_clinic_data)
                                        @if($row->id == $selected_clinic_data->id)
                                            {{$selected = 'selected'}}
                                        @endif
                                    @endif
                                    <option {{$selected}} value="{{$row->id}}">{{ucfirst($row->application_title)}}</option>
                                @endforeach
                        </select>
                    </div>
                    <div class="ibox-footer">
                        <button title="Submit" class="btn btn-primary mr-2" type="submit" name="btn-submit" value="submit">{{__('Save User')}}</button>
                        <!-- <button class="btn btn-outline-secondary" type="reset">Cancel</button> -->
                    </div>
                </form>
            </div>
        </div>
    </div>
</div>

<!-- JS FORM VALIDATION -->

<script src="//ajax.googleapis.com/ajax/libs/jquery/1.10.2/jquery.min.js"></script>
<script src="//cdnjs.cloudflare.com/ajax/libs/jquery-form-validator/2.3.26/jquery.form-validator.min.js"></script>
<script>
  $.validate({
    lang: 'en'
  });
</script>
@endsection

