@extends('physician.layouts.master')
@section('content')
  <?php
   $success = false; ?>
    @if (\Session::has('error'))
        <div class="alert alert-danger">
            {!! \Session::get('error') !!}
        </div>
    @endif
    @if (\Session::has('success'))
    <?php $success = true; ?> 
        <div class="alert alert-success">
            {!! \Session::get('success') !!}
        </div>
    @endif
    @if ($errors->any())
          <div class="alert alert-danger">
              <ul>
                  @foreach ($errors->all() as $error)
                      <li>{{ $error }}</li>
                  @endforeach
              </ul>
          </div>
    @endif
    <div class="page-content fade-in-up">
     <div class="row">
        <div class="col-md-12">
            <div class="ibox">
                <form class="form-purple" action="{{ $route }}" method="post" >
                    <input type="hidden" name="questionCatagoryId" value="{{$categoryData->id}}">
                    <div class="ibox-head">
                        <div class="ibox-title">{{@$heading}}</div>
                    </div>
                    <div class="ibox-body col-md-8">
                        <div class="form-group mb-4">
                            <label>{{ __('Title') }}</label>
                            <input class="form-control" value="{{old('title', $categoryData->title )}}" name="title"  type="text">
                        </div>
                         <div class="form-group mb-4">
                            <label>{{ __('Sort Order') }}</label>
                            @if($categoryData->question_order)
                            @php($suggestedSortOrder = $categoryData->question_order)
                            
                            @endif
                            <input class="form-control" value="{{ old('question_order',$suggestedSortOrder)}}" name="question_order"  type="text">
                        </div> 
                    </div>  
                    <div class="ibox-footer">
                        <button title="Submit" class="btn btn-primary mr-2" type="submit" name="btn-submit" value="submit">{{__('Submit')}}</button>
                        <!-- <button class="btn btn-outline-secondary" type="reset">Cancel</button> -->
                    </div>
                </form>
            </div>
        </div>
    </div>
</div>

<!-- JS FORM VALIDATION -->

<script src="//ajax.googleapis.com/ajax/libs/jquery/1.10.2/jquery.min.js"></script>
<script src="//cdnjs.cloudflare.com/ajax/libs/jquery-form-validator/2.3.26/jquery.form-validator.min.js"></script>
<script>
  $.validate({
    lang: 'en'
  });
</script>
<!-- <script type="text/javascript">
    $(document).ready(function() {
    var max_fields      = 10; //maximum input boxes allowed
    var wrapper         = $(".input_fields_wrap"); //Fields wrapper
    var add_button      = $("#add_field_button"); //Add button ID
    
    var x = 1; //initlal text box count
    $(add_button).click(function(e){ //on add input button click
        e.preventDefault();
        if(x < max_fields){ //max input box allowed
            x++; //text box increment
            $(wrapper).append('<label>{{ __('Question') }}</label><div><input class="form-control" type="text" name="questionOptions[]"/><label>{{ __('Question Options Sort Order') }}</label><input class="form-control" name="question_options_sort_order[]" data-validation="required" type="text" value=""><button href="#" id="remove_field" class="float-lg-right btn btn-outline-success btn-icon-only btn-circle btn-sm btn-thick"><i class="la la-minus"></i></button></div>'); //add input box
        }
    });
    
    $(wrapper).on("click","#remove_field", function(e){ //user click on remove text
        e.preventDefault(); $(this).parent('div').remove(); x--;
    })
});
</script> -->
@endsection

