@extends('physician.layouts.master')
@section('content')
  <?php $success = false; ?>
    @if (\Session::has('error'))
        <div class="alert alert-danger">
            {!! \Session::get('error') !!}
        </div>
    @endif
    @if (\Session::has('success'))
    <?php $success = true; ?> 
        <div class="alert alert-success">
            {!! \Session::get('success') !!}
        </div>
    @endif
<div class="page-content fade-in-up">
    <div class="ibox">
        <div class="ibox-body">
            <h5 class="font-strong mb-4">{{__('Question Listing')}}</h5>
               
              
               <div class="row">

                    <div class="col-md-12">                          
                        <form class="form-info form-inline1 form-search " action="javascript:;">
                            <div class="ibox-body" >
                                <div class="row">
                                    <div class="col-sm-3 form-group">
                                        <label>Search</label>
                                        <input class="form-control text-search" type="text" placeholder="">
                                        
                                    </div>
                                    <div class="col-sm-3 form-group">
                                        <label>Chief Complain</label>
                                        <!-- <input class="form-control complain-search" name="complainType" type="text" placeholder=""> -->
                                         <select class="form-control complain-search">
                                                <option value="">- Any -</option>
                                                @if($cheifComplainTypes)
                                                    @foreach($cheifComplainTypes as $row )
                                                    @if($row->status == 0)
                                                    @php($status = ' (Inactive)')
                                                    @else
                                                    @php($status = '')
                                                    @endif
                                                        <option  value="{{ $row->id  }}">{{ $row->name}}{{ $status }}</option>
                                                    @endforeach
                                                @endif
                                        </select>
                                    </div>
                                    <div class="col-sm-3 form-group">
                                        <label>Question Category</label>
                                        <select class="form-control category-search" >
                                                <option value="">- Any -</option>
                                                @if($questionCategories)
                                                    @foreach($questionCategories as $row )
                                                        @if($row->status == 0)
                                                        @php($status = ' (Inactive)')
                                                        @else
                                                        @php($status = '')
                                                        @endif
                                                        <option  value="{{ $row->id }}">{{ $row->title }}{{ $status }}</option>
                                                    @endforeach
                                                @endif
                                        </select>
                                    </div>
                                    <div class="col-sm-3 form-group">
                                        <label>Status</label>

                                        <div class="row last-row">

                                            <div class="col-sm-6 form-group element-1" >

                                                    <select class="form-control status-search" name="status" >
                                                            <option value="">- Any -</option>
                                                            <option value="1">Active</option>
                                                            <option value="0">Inactive</option>
                                                    </select>

                                            </div>

                                            <div class="col-sm-6 form-group element-2" >
                                                <button class="btn btn-info button-search" type="button">Search</button>
                                            </div>
                                        </div>
                                         
                                    </div>
                                </div>                               
                            </div>
                        </form>
                    </div>

               </div>
               
                <table
                    class="table table-bordered table-hover" 
                    id="questions" 
                    data-source = "{{ route('Questions_ajax') }}"
                    data-cols = ",,,,,"
                    data-search = "false"
                    >
                    <thead class="thead-default thead-lg">
                         <tr>
                            <th width="15%">Chief Complain</th>
                            <th width="15%">Category</th>
                            <th width="30%">Question</th>
                            <!-- <th width="10%">Sort Order</th> -->
                            <th width="20%">Options</th>
                            <th width="5%">Status</th>
                            <th width="5%">Actions</th>
                        </tr>
                    </thead>
                </table>
        </div>
    </div>
</div>

        <!-- END PAGE CONTENT-->
@endsection

@section('scripts')
<script>
    DataTable.initDataTable('#questions');
    $('.button-search').click(function()
    {   
        DataTable.reDraw(); 
    });

</script>
@endsection