@extends('physician.layouts.master')
@section('content')
  <?php $success = false; ?>
    @if (\Session::has('error'))
        <div class="alert alert-danger">
            {!! \Session::get('error') !!}
        </div>
    @endif
    @if (\Session::has('success'))
    <?php $success = true; ?> 
        <div class="alert alert-success">
            {!! \Session::get('success') !!}
        </div>
    @endif
<div class="page-content fade-in-up">
    <div class="ibox">
        <div class="ibox-body">
            <h5 class="font-strong mb-4">{{__('Pending Question Listing')}}</h5>
              
                <table
                    class="table table-bordered table-hover" 
                    id="questions" 
                    data-source = "{{ route('pending_questions_ajax') }}"
                    data-cols = ",,,,"
                    data-search = "false"
                    >
                    <thead class="thead-default thead-lg">
                         <tr>
                            <th width="15%">Surgeon</th>
                            <th width="15%">Chief Complain</th>
                            <th width="15%">Category</th>
                            <th width="20%">Title</th>
                            <th width="30%">Response</th>
                        </tr>
                    </thead>
                </table>
        </div>
    </div>
</div>

    <!-- END PAGE CONTENT-->
@endsection

@section('scripts')
<script>
    DataTable.initDataTable('#questions');
    $('.button-search').click(function()
    {   
        DataTable.reDraw(); 
    });

</script>
@endsection