<?php

namespace App\Http\Controllers;

use Illuminate\Http\Request;
use App\Models\Roles;
use App\Models\FormEnteries;
use DateTime;

use Auth;
use App\User;
use App\Helpers\CommonHelper;
use Illuminate\Support\Facades\Config;
use DB;

class AdminController extends Controller
{
    /**
     * Create a new controller instance.
     *
     * @return void
     */
    public function __construct()
    {
        $this->middleware('auth');
    }

    /**
     * Show the application dashboard.
     *
     * @return \Illuminate\Contracts\Support\Renderable 
     */
    public function index()
    {   
        return view('admin.dashboard');
    }

// 
    public function saveusers(Request $request, $id=false)
    {
        $data['roleData']           = Roles::get();
        $data['id']                 = $id;
        $data['selectedRoles']      = array();
        $data['userData']           = user::find($id);
        
        
        if($request->input('btn-submit'))
        {   
           

            $roleId                                   = $request->input('roles');
            $data['id']                               = $request->input('userId');
            $data['name']                             = $request->input('name');
            $data['email']                            = $request->input('email');
            $data['password']                         = bcrypt($request->get('password'));
            $userRoles                                = array(); 

            $user = User::updateOrCreate(
                ['id' => $data['id']],
                $data
            );
            $roleId  = $request->input('roles');
            if($data['id'])
            {
                $user = User::find($data['id']);
                $user->roles()->detach($user->role_id);
            }
            foreach ($roleId as $key => $value) 
            {
                $user->roles()->attach($value);
            }
            // DETACH ALL ROLES OF CURRENT ID

            return redirect(route('admin_users_listing'))->with('success', 'User save Successfully!');

        }
       
        return view('admin.notifications.form',$data);
    }


    //  SHOW PUSH NOTIFICATIONS
    public function usersListing()
    {   
        return view('admin.notifications.listing');
    }

    //  CREATE DATATABLE FOR PUSH NOTIFICATIONS
    public function usersAjax(Request $request)
    {
        $_getParams             = $_GET;
        $params                 = CommonHelper::_processDataTableRequest($_getParams);
        
        $draw                   = $params['draw'];      
        $offset                 = $params['offset'];
        $searchKeyword          = $params['search_keyword'];
        $sortColumn             = $params['sort_column'];
        $sortOrderDirection     = $params['sort_direction'];
        $recordsPerPage         = $params['records_per_page'];
        $objUsers             =  new User();

        $recordsTotal           = $objUsers->count();
        $recordsFiltered        = $recordsTotal;

        $recordsFiltered = $objUsers->count();
     
        $objUsers         = $objUsers->orderby('created_at', 'DESC')->get();
        $listData = array(); 
        //dd($objUsers);die;         
        foreach ($objUsers as $row) 
        {           
            $deletePath = route('admin_users_delete', $row->id);
            $editPath   = route('admin_users_save', $row->id);

            $tplActions  = <<<EOT
            <a title="Edit" class="la la-pencil" href="$editPath" value="edit"><i class="" aria-hidden="true"></i></a>
            <a title="Delete" class="ti-trash" onclick="return confirm('Are you sure want to delete this record?')" href="$deletePath"><i class="" aria-hidden="true"></i></a>
EOT;
            
            $tempArray  = array();
            $roles      = array();
            $userRoles  = $row->load('roles');
            foreach ($userRoles->roles as $key => $value) {
               $roles[] = $value->name;
            }
            $tempArray[]    = $row->name;
            $tempArray[]    = $row->email;
            $tempArray[]    = implode(' </br> ', $roles);
            $tempArray[]    = $tplActions;
            $listData[]     = $tempArray;
        }
        $data = array(
            "draw"            => $draw,
            "recordsTotal"    => $recordsTotal,
            "recordsFiltered" => $recordsFiltered,
            "data"            => $listData
        );
        
        return response()->json($data);
    }

    //  DELETE NOTIFICATIONS
    public function deleteUsers($id)
    {
        if($id)
        {   
            $User   = User::find($id);
            if(!$User)
            {
                // Redirect to base
                return redirect(route('admin_users_listing'));
            }
            $User->where('id', $id)->delete();
            return redirect()->back()->with('success', 'User has been deleted successfully!');
            return redirect(route('admin_users_listing'));
        }
    }

}
