<?php

namespace App\Http\Controllers;
use Illuminate\Http\Request;
use App\Helpers\CommonHelper;
use App\Helpers\WpAPI;
use App\User;
use Validator;
use Hash;
use Config;
use Illuminate\Support\Facades\DB;
use App\Http\Controllers\Controller;
use Corcel\Model\Post as WordpressPost;
use Carbon\Carbon;
use Illuminate\Mail\Message;
use Illuminate\Support\Facades\Password;

use App\Helpers\SalesforceHelper;
use Illuminate\Support\Facades\File;

use App\Models\AccessToken;
use App\Models\SystemOnePlaceInterests;
use App\Models\UserSystemIds;
use App\Models\LogsAPIs;

//-->use App\Models\UserReadingList;
//-->use App\Models\UserFolderArticles;

use App\Models\UserFolders;
use App\Models\UserLibrary;

use App\Models\Matters;
use App\Models\MatterInvoices;
use App\Models\ConnectData;
use App\Models\UserMatterFavourites;

use App\Models\SystemOnePlaceEvents;
use App\Models\SystemOnePlaceEventSpeakers;
use App\Models\SystemOnePlaceEventUsers;

use Auth;
use Mail;

class TestController extends Controller
{
    public function welcome()
    {
        echo 'Welcome!';
        exit;
    }

    public function samlCallback(Request $request)
    {
        $SAMLResponse = @$_REQUEST['SAMLResponse'];

        if($SAMLResponse)
        {
            $SAMLResponse = base64_decode($SAMLResponse);

            header ("Content-Type:text/xml");
            echo $SAMLResponse;
            exit;

        }

        echo '<pre>';
        print_r($_GET);

        print_r($_POST);
        echo '</pre>';

        exit;

        /*
            <?xml version="1.0" encoding="UTF-8"?>
<saml2p:Response Destination="http://tamimi-app.theprojectstagingserver.com/saml/callback" ID="_41bcc67b9f78f1e0f790812fc4076ac3" IssueInstant="2019-03-12T11:15:24.903Z" Version="2.0" xmlns:saml2p="urn:oasis:names:tc:SAML:2.0:protocol" xmlns:xsd="http://www.w3.org/2001/XMLSchema"><saml2:Issuer xmlns:saml2="urn:oasis:names:tc:SAML:2.0:assertion">https://samltest.id/saml/idp</saml2:Issuer><ds:Signature xmlns:ds="http://www.w3.org/2000/09/xmldsig#"><ds:SignedInfo><ds:CanonicalizationMethod Algorithm="http://www.w3.org/2001/10/xml-exc-c14n#"/><ds:SignatureMethod Algorithm="http://www.w3.org/2001/04/xmldsig-more#rsa-sha256"/><ds:Reference URI="#_41bcc67b9f78f1e0f790812fc4076ac3"><ds:Transforms><ds:Transform Algorithm="http://www.w3.org/2000/09/xmldsig#enveloped-signature"/><ds:Transform Algorithm="http://www.w3.org/2001/10/xml-exc-c14n#"><ec:InclusiveNamespaces PrefixList="xsd" xmlns:ec="http://www.w3.org/2001/10/xml-exc-c14n#"/></ds:Transform></ds:Transforms><ds:DigestMethod Algorithm="http://www.w3.org/2001/04/xmlenc#sha256"/><ds:DigestValue>O+qtJxvWqIQixgpX8UEwg235tkANyfrgGSzljcDPCgU=</ds:DigestValue></ds:Reference></ds:SignedInfo><ds:SignatureValue>Y7P3n+zz3EFvwT1lCJ2alVe5bvLRCbKwcIWoNrjoiPqt8qvusik89wfFuNTaiabRQ6bca94KpE8S0TKpEoPez9uboyTTEpBHcjVY8b12t45l61ws6CEGZdcVuPbldC1kSvHGp0mOM4Nldb7vzpEQSCALEDWALirJmIUrny7RgNx5tAmjML7Ms4sQVvNSmWBHxJqo9lpiM7W0ine0bbBvbJbFNHzWXtRtaLeWVdN2d6eIKI0vS+QnbtdchYiqoiqSoYZH9+5yXV1cjpREFZyx6Ermk3dVEmdAuK2PS/95wWyBAIZf9vbzyD03JVQaS0YDlOW+mvlBgdbb4WO3kc7bSw==</ds:SignatureValue><ds:KeyInfo><ds:X509Data><ds:X509Certificate>MIIDEjCCAfqgAwIBAgIVAMECQ1tjghafm5OxWDh9hwZfxthWMA0GCSqGSIb3DQEBCwUAMBYxFDAS
BgNVBAMMC3NhbWx0ZXN0LmlkMB4XDTE4MDgyNDIxMTQwOVoXDTM4MDgyNDIxMTQwOVowFjEUMBIG
A1UEAwwLc2FtbHRlc3QuaWQwggEiMA0GCSqGSIb3DQEBAQUAA4IBDwAwggEKAoIBAQC0Z4QX1NFK
s71ufbQwoQoW7qkNAJRIANGA4iM0ThYghul3pC+FwrGv37aTxWXfA1UG9njKbbDreiDAZKngCgyj
xj0uJ4lArgkr4AOEjj5zXA81uGHARfUBctvQcsZpBIxDOvUUImAl+3NqLgMGF2fktxMG7kX3GEVN
c1klbN3dfYsaw5dUrw25DheL9np7G/+28GwHPvLb4aptOiONbCaVvh9UMHEA9F7c0zfF/cL5fOpd
Va54wTI0u12CsFKt78h6lEGG5jUs/qX9clZncJM7EFkN3imPPy+0HC8nspXiH/MZW8o2cqWRkrw3
MzBZW3Ojk5nQj40V6NUbjb7kfejzAgMBAAGjVzBVMB0GA1UdDgQWBBQT6Y9J3Tw/hOGc8PNV7JEE
4k2ZNTA0BgNVHREELTArggtzYW1sdGVzdC5pZIYcaHR0cHM6Ly9zYW1sdGVzdC5pZC9zYW1sL2lk
cDANBgkqhkiG9w0BAQsFAAOCAQEASk3guKfTkVhEaIVvxEPNR2w3vWt3fwmwJCccW98XXLWgNbu3
YaMb2RSn7Th4p3h+mfyk2don6au7Uyzc1Jd39RNv80TG5iQoxfCgphy1FYmmdaSfO8wvDtHTTNiL
ArAxOYtzfYbzb5QrNNH/gQEN8RJaEf/g/1GTw9x/103dSMK0RXtl+fRs2nblD1JJKSQ3AdhxK/we
P3aUPtLxVVJ9wMOQOfcy02l+hHMb6uAjsPOpOVKqi3M8XmcUZOpx4swtgGdeoSpeRyrtMvRwdcci
NBp9UZome44qZAYH1iqrpmmjsfI9pJItsgWu3kXPjhSfj1AJGR1l9JGvJrHki1iHTA==</ds:X509Certificate></ds:X509Data></ds:KeyInfo></ds:Signature><saml2p:Status><saml2p:StatusCode Value="urn:oasis:names:tc:SAML:2.0:status:Success"/></saml2p:Status><saml2:Assertion ID="_b050cda1062de865011b9f5e47fac6c1" IssueInstant="2019-03-12T11:15:24.903Z" Version="2.0" xmlns:saml2="urn:oasis:names:tc:SAML:2.0:assertion"><saml2:Issuer>https://samltest.id/saml/idp</saml2:Issuer><saml2:Subject><saml2:NameID Format="urn:oasis:names:tc:SAML:2.0:nameid-format:transient" NameQualifier="https://samltest.id/saml/idp" SPNameQualifier="http://tamimi-app.theprojectstagingserver.com" xmlns:saml2="urn:oasis:names:tc:SAML:2.0:assertion">AAdzZWNyZXQxXT1rf8AiQ8XOli15QOQF+AqR5uBfQw73FpKYQPtHbkixRbKBSJHXwsCdVmyk9tgVcruxYrIAzJzRL1DXw18Xh3sDdPhzKlGz92xxV1cw3RCzgNqo5tQ+WLbzOx/sNYC3QX4vZK1wGFrYGlWBn/32qQ==</saml2:NameID><saml2:SubjectConfirmation Method="urn:oasis:names:tc:SAML:2.0:cm:bearer"><saml2:SubjectConfirmationData Address="45.116.232.29" NotOnOrAfter="2019-03-12T11:20:24.908Z" Recipient="http://tamimi-app.theprojectstagingserver.com/saml/callback"/></saml2:SubjectConfirmation></saml2:Subject><saml2:Conditions NotBefore="2019-03-12T11:15:24.903Z" NotOnOrAfter="2019-03-12T11:20:24.903Z"><saml2:AudienceRestriction><saml2:Audience>http://tamimi-app.theprojectstagingserver.com</saml2:Audience></saml2:AudienceRestriction></saml2:Conditions><saml2:AuthnStatement AuthnInstant="2019-03-12T10:48:18.217Z" SessionIndex="_de3a7742c5f1b5155ac09d502413e3ed"><saml2:SubjectLocality Address="45.116.232.29"/><saml2:AuthnContext><saml2:AuthnContextClassRef>urn:oasis:names:tc:SAML:2.0:ac:classes:PasswordProtectedTransport</saml2:AuthnContextClassRef></saml2:AuthnContext></saml2:AuthnStatement><saml2:AttributeStatement><saml2:Attribute FriendlyName="uid" Name="urn:oid:0.9.2342.19200300.100.1.1" NameFormat="urn:oasis:names:tc:SAML:2.0:attrname-format:uri"><saml2:AttributeValue>rick</saml2:AttributeValue></saml2:Attribute><saml2:Attribute Name="urn:oasis:names:tc:SAML:attribute:subject-id" NameFormat="urn:oasis:names:tc:SAML:2.0:attrname-format:uri"><saml2:AttributeValue xmlns:xsi="http://www.w3.org/2001/XMLSchema-instance" xsi:type="xsd:string">rsanchez@samltest.id</saml2:AttributeValue></saml2:Attribute><saml2:Attribute FriendlyName="mail" Name="urn:oid:0.9.2342.19200300.100.1.3" NameFormat="urn:oasis:names:tc:SAML:2.0:attrname-format:uri"><saml2:AttributeValue>rsanchez@samltest.id</saml2:AttributeValue></saml2:Attribute><saml2:Attribute FriendlyName="sn" Name="urn:oid:2.5.4.4" NameFormat="urn:oasis:names:tc:SAML:2.0:attrname-format:uri"><saml2:AttributeValue>Sanchez</saml2:AttributeValue></saml2:Attribute><saml2:Attribute FriendlyName="displayName" Name="urn:oid:2.16.840.1.113730.3.1.241" NameFormat="urn:oasis:names:tc:SAML:2.0:attrname-format:uri"><saml2:AttributeValue>Rick Sanchez</saml2:AttributeValue></saml2:Attribute><saml2:Attribute FriendlyName="givenName" Name="urn:oid:2.5.4.42" NameFormat="urn:oasis:names:tc:SAML:2.0:attrname-format:uri"><saml2:AttributeValue>Rick</saml2:AttributeValue></saml2:Attribute></saml2:AttributeStatement></saml2:Assertion></saml2p:Response>
        */
    }

    public function samlCallbackXmlParse()
    {
        $xmlstring = '
<samlp:Response ID="_a6499edc-2c0a-4f90-998d-6b1bd8f153a6" Version="2.0" IssueInstant="2019-03-27T07:44:05.211Z" Destination="https://tamimi-app.theprojectstagingserver.com/saml/callback" Consent="urn:oasis:names:tc:SAML:2.0:consent:unspecified" InResponseTo="TAMIMI_APP_809707f0030a5d00620c9d9df97f627afe9dcc24_7" xmlns:samlp="urn:oasis:names:tc:SAML:2.0:protocol"><Issuer xmlns="urn:oasis:names:tc:SAML:2.0:assertion">http://adfs.tamimi.com/adfs/services/trust</Issuer><samlp:Status><samlp:StatusCode Value="urn:oasis:names:tc:SAML:2.0:status:Success" /></samlp:Status><Assertion ID="_604214e2-f408-43cd-9849-c4e872a363e5" IssueInstant="2019-03-27T07:44:05.211Z" Version="2.0" xmlns="urn:oasis:names:tc:SAML:2.0:assertion"><Issuer>http://adfs.tamimi.com/adfs/services/trust</Issuer><ds:Signature xmlns:ds="http://www.w3.org/2000/09/xmldsig#"><ds:SignedInfo><ds:CanonicalizationMethod Algorithm="http://www.w3.org/2001/10/xml-exc-c14n#" /><ds:SignatureMethod Algorithm="http://www.w3.org/2001/04/xmldsig-more#rsa-sha256" /><ds:Reference URI="#_604214e2-f408-43cd-9849-c4e872a363e5"><ds:Transforms><ds:Transform Algorithm="http://www.w3.org/2000/09/xmldsig#enveloped-signature" /><ds:Transform Algorithm="http://www.w3.org/2001/10/xml-exc-c14n#" /></ds:Transforms><ds:DigestMethod Algorithm="http://www.w3.org/2001/04/xmlenc#sha256" /><ds:DigestValue>vdpnZ53QzwrtFRpDhOf6EO0VGu6rAQhlia8E3ZRP5js=</ds:DigestValue></ds:Reference></ds:SignedInfo><ds:SignatureValue>UR7QwVZzbKubbVlyFasG6k3Hx1CFtYa6kpf/GPZizap7CmDMjETWEbRb3eBSk/9KLP5Y3qHC54W1gXzvlqhAppNnWxT7yOExHClDZjs3Q2m3trtZR/cOz+zop7aylI3HnHzZMEmFuZyOJXV+KkE7pyfD1/oA/eeaxjaltZelwPp3H/2EERw/AgfDMjG+WxIH1S/KQ6yHyjAZrCQbK/qRaoiQhxBikXrtN7xDtp2w0EKdGOqtaxI4dIA5p9X5kNYoawMrR00vD2p1VU0ioydO457fLlQIPAd5YWh+GaucSxR7zGGwJIzmDHwP42sXrNeKB4Nhg7hqRWMWTlRJI+uH2A==</ds:SignatureValue><KeyInfo xmlns="http://www.w3.org/2000/09/xmldsig#"><ds:X509Data><ds:X509Certificate>MIIC2jCCAcKgAwIBAgIQH+ZZ/zliOoFLpHqMpbsB/TANBgkqhkiG9w0BAQsFADApMScwJQYDVQQDEx5BREZTIFNpZ25pbmcgLSBhZGZzLnRhbWltaS5jb20wHhcNMTkwMzIyMTAzNDEwWhcNMjkwMzE5MTAzNDEwWjApMScwJQYDVQQDEx5BREZTIFNpZ25pbmcgLSBhZGZzLnRhbWltaS5jb20wggEiMA0GCSqGSIb3DQEBAQUAA4IBDwAwggEKAoIBAQC1bNBV4nCgz1kjOIc1Xf/ZtiyeusGKXcEGdq2CzsWlFmHb6iaeQFI7HTPLHwz8mVB/q/pTFqn9FcOhB4JGE7CNKYJk/Sp9qNLqBMbtWQyja+Dg/P8RnmMbjkH0zSq1CAGGIuiI3NAXitO37VHOpuspSG146YiTIrnkZAlIITObWfr07Zt8jQFbFmW1AkDFXorcOM7a6gPL2ZSAalGw9f137h+BbpnUsnZgHJ5qZeVrMr5VU3hy4UaOghUkG51e+HQw4OlGog1IgPIlAQuF0xLMlmHK57FZdO05dxiY4JjD1XuvDSud66DDLZdqNKBnBHuVuQuHuc9LkzkPIkocFkFTAgMBAAEwDQYJKoZIhvcNAQELBQADggEBAIpaaR506NUk1bqW/StbLG8QftgKEJvd35R4HcnZlVsML2FiUKw2oyDBBjU1eCGi/tYC02cHu+IJL2zVO3Pw6vuRGbKFL4OOzm0wZVXFlqpiiqrpJwJ0lEjiLgA9q65sJXl33lpVOFqFgGMRpffXKIr/siA0PgMRh1nodgZ0TulANNmOldrPmR1gVb3n8mw+1llX8MfUiJeCebIAKh17z+PHWw9VbQCpZL2n6TzmubgpSoZ4TbG6UlDTNDu4ufLwPUa4aP9vs+guDujZ+IjGTBEptWTH8cRqDHXZOWeJjVRC2pWz6BavRzfvPvO4szzP+Aeu8A/rzDQYnxUsoVPV8bo=</ds:X509Certificate></ds:X509Data></KeyInfo></ds:Signature><Subject><SubjectConfirmation Method="urn:oasis:names:tc:SAML:2.0:cm:bearer"><SubjectConfirmationData InResponseTo="TAMIMI_APP_809707f0030a5d00620c9d9df97f627afe9dcc24_7" NotOnOrAfter="2019-03-27T07:49:05.211Z" Recipient="https://tamimi-app.theprojectstagingserver.com/saml/callback" /></SubjectConfirmation></Subject><Conditions NotBefore="2019-03-27T07:44:05.211Z" NotOnOrAfter="2019-03-27T08:44:05.211Z"><AudienceRestriction><Audience>https://tamimi-app.theprojectstagingserver.com
    </Audience></AudienceRestriction></Conditions><AttributeStatement><Attribute Name="Email"><AttributeValue>adfs.test@tamimi.com</AttributeValue></Attribute><Attribute Name="FirstName"><AttributeValue>Create Media</AttributeValue></Attribute><Attribute Name="LastName"><AttributeValue>ADFS Test</AttributeValue></Attribute><Attribute Name="UserName"><AttributeValue>adfs.test</AttributeValue></Attribute></AttributeStatement><AuthnStatement AuthnInstant="2019-03-27T07:44:04.977Z"><AuthnContext><AuthnContextClassRef>urn:oasis:names:tc:SAML:2.0:ac:classes:PasswordProtectedTransport</AuthnContextClassRef></AuthnContext></AuthnStatement></Assertion></samlp:Response>';




        $xml = simplexml_load_string($xmlstring, "SimpleXMLElement");

        /*
        echo '<pre>';
        print_r($xml->Assertion->AttributeStatement->Attribute->attributes());
        exit;
        */

        //$xml = str_replace('@attributes', '_attributes', $xml);

        /*
        $states = array();
        foreach($xml->children() as $state)
        {
            $states[]= array('state' => $state->name); 
        } 
        */

        $samlInfo = array();

        foreach($xml->attributes() as $a => $b)
        {
            $a = (string) $a;
            $b = (string) $b;

            $samlInfo[$a] = $b;
        }


        foreach($xml->Assertion->AttributeStatement->Attribute as $k => $v)
        {
            foreach($v->attributes() as $a => $b)
            {
                $b = (string) $b;
                $attributeValue = (string) $v->AttributeValue;
                
                $samlInfo[$b] = $attributeValue;
            }
        }

        echo '<pre>';

        print_r($samlInfo);

        echo '</pre>';



        /* - */
        echo '<pre>';
        echo '<br />------------------<br />';
        print_r($xml);


        //print_r($states);
        exit;
        
    }

    function samlLogin()
    {
        /*

        $xml = '<?xml 
version="1.0" 
encoding="UTF-8"?>
<samlp:AuthnRequest 
    xmlns:samlp="urn:oasis:names:tc:SAML:2.0:protocol" 
    AssertionConsumerServiceURL="https://tamimi.my.salesforce.com?
    so=00D1H000000OaRb" 
    Destination="https://adfs.tamimi.com/adfs/ls/" 
    ID="_2CAAAAWpFD-_xME8wMXQwMDAwMDA0Qzk1AAAA2iuwzx6b3vqkc9-ZjP1KtGjnD7zJOMrh4gWsptgP7dozuZSjREee8SihlxiM4pWLEXvqfS6hJE20eJpCRkiqeZBONsp67EcJRDPiEIynnyKAtuh_JYo3zbouzQ1mqo9yCQ0H3Sng31l4Wq9rx3Vl2XNg4ChtOakJnsoTgtm3vS_Yp8f9igk8dses1VX9VFkeSZkYiijt1RPB9M_diJ8r6dfIcWmkFBZYgv-10Ei_CMaZkNPiydPILCsBTAKW6wEsFg" 
    IssueInstant="2019-03-25T12:40:34.659Z" 
    ProtocolBinding="urn:oasis:names:tc:SAML:2.0:bindings:HTTP-POST" 
    Version="2.0">
    <saml:Issuer 
        xmlns:saml="urn:oasis:names:tc:SAML:2.0:assertion">https://tamimi.my.salesforce.com
    </saml:Issuer>
</samlp:AuthnRequest>';

*/


        /*


        $abc = 'hZJdb6pAEIb%2FCtl7kQ8BIcUGxM9KVURRb8wWFkWBld1FxV9fqm3Sc9MzyV5MZuZ9J7PPy%2BstS7kLIjTBuQlEXgAcykMcJfneBEu%2F32iD184LhVl6NqySHXIPFSWijKvncmo8CiYoSW5gSBNq5DBD1GChsbDciSHxgnEmmOEQp4CzKEWE1UZdnNMyQ2SByCUJ0dKbmODA2JkazSaDWZIlfFbxFKaIxpiEiA9x9kqxKQiOOBQeMYXeB%2BCcepMkh%2Byx%2FI8CjGLKf8vUg4%2B8mdIm4EaOCXZS16ojOPdtZ%2B25vfbVXc%2BvrmN9PWF%2BP4lfZSkdX3crsejNN%2FJG9A4EX%2BUdpTh4GwbupDz0NOe4Hne3ErZP8maThXAsWLAMxHZ0i101g6pYFpuTcD%2FSQ4Babn88GvgfO1%2BP6Jjtu5O3ypsTeJwqlr4gftBeXVjJBro%2BJfl7ZDs40m5VEOkRchI214tte8na8F5BdY3C6KLaPSVVlPvlojEZve9mA8G6DenuptjecnZu9PsloYX3Fp6EVlzEVL5VZBptVTVWZ9UyzsLWQO5pV7%2BI0bA89CtJpgqyRx72VS0LVsfuXt3X16K0RKOcMpgzE0iCqDcEuSEpvigZkma0FF4T1C3gZt8fbCf5E5u%2FaPh4NlFj6Puzxmy68AG3%2BsGvbgBP2IyHOflF2d%2By8Act0PkfSC%2FNXwadZ%2FYv251P&RelayState=%2Fvisualforce%2Fsession%3Furl%3Dhttps%253A%252F%252Ftamimi.lightning.force.com%252Flightning%252Fpage%252Fhome&SigAlg=http%3A%2F%2Fwww.w3.org%2F2001%2F04%2Fxmldsig-more%23rsa-sha256&Signature=a6FcIrtdhG5IuocGUc1Cq%2Bh0DH5fo8Y4BHPL46RyruqyQ29nZ1YErDEIO8Yua8maLpQaIZvQU3b5V3oiqT%2Bzr9JlVEbYE53KDdrhb7zlY1dllTMlq38BhsUiVsioMlwC%2FLaQgL9fVxFsR0fFdEL4IyIK13fHcjtHJG%2BFIp7v6OnDpEZAUh9XZknDd2CfNqVX5s%2BhiUUOb6MUpst7hLJ5lhCXwbbHps%2BGuxtu9Al1qaQ9Cfa94PK8xms30x4D%2Bl6dCjIcknbUDVfUV9GebT13zzECeAnmA27ZIVb%2Fx5Lnvnl0fW0lHIYKrUSK9UtIwSzN7SOnSn11bZ01mOTFZvh19A%3D%3D';


        echo gzinflate(base64_decode(urldecode($abc)));
        exit;
         
         */

        /*
            Email Address: adfs.test@tamimi.com

Password       : P\KBg\P(k47]

 
        */

        $IssueInstant = '2019-03-26T12:40:34.659Z';


        $xml = '<?xml 
version="1.0" 
encoding="UTF-8"?>
<samlp:AuthnRequest 
    xmlns:samlp="urn:oasis:names:tc:SAML:2.0:protocol" 
    AssertionConsumerServiceURL="https://tamimi-app.theprojectstagingserver.com/saml/callback" 
    Destination="https://adfs.tamimi.com/adfs/ls/" 
    ID="TAMIMI_APP_809707f0030a5d00620c9d9df97f627afe9dcc24_7" 
    IssueInstant="'. $IssueInstant .'" 
    ProtocolBinding="urn:oasis:names:tc:SAML:2.0:bindings:HTTP-POST" 
    Version="2.0">
    <saml:Issuer 
        xmlns:saml="urn:oasis:names:tc:SAML:2.0:assertion">https://tamimi-app.theprojectstagingserver.com
    </saml:Issuer>
</samlp:AuthnRequest>';

        $link = 'https://adfs.tamimi.com/adfs/ls/?SAMLRequest=' . urlencode(base64_encode(gzdeflate($xml)));

        return redirect($link);
    }
}
