@extends('physician.layouts.master')
@section('content')
  <?php $success = false; ?>
    @if (\Session::has('error'))
        <div class="alert alert-danger">
            {!! \Session::get('error') !!}
        </div>
    @endif
    @if (\Session::has('success'))
    <?php $success = true; ?> 
        <div class="alert alert-success">
            {!! \Session::get('success') !!}
        </div>
    @endif
     @if ($errors->any())
          <div class="alert alert-danger">
              <ul>
                  @foreach ($errors->all() as $error)
                      <li>{{ $error }}</li>
                  @endforeach
              </ul>
          </div>
    @endif
    <div class="page-content fade-in-up">
     <div class="row">
        <div class="col-md-12">
            <div class="ibox">
                <form class="form-purple" action="{{ route('chief_complains_save') }}" method="post"  enctype="multipart/form-data">
                    <input type="hidden" name="chiefComplaintsId" value="{{@$chiefComplaints->id}}">
                    <div class="ibox-head">
                        <div class="ibox-title">{{@$heading}}</div>
                    </div>
                    <div class="ibox-body col-md-8">
                        <div class="form-group mb-4">
                            <label>{{ __('Title') }}</label>
                            <input class="form-control" name="name" data-validation="required" type="text" placeholder="Neuro Dignostics" value="{{@$chiefComplaints->name}}">
                        </div> 
                        <div class="form-group mb-4">
                            <label>{{ __('Front Image') }}</label>
                            @if(@$chiefComplaints->image_front)
                            <input type="image" src="{{$chiefComplaints->image_front}}">
                            @endif
                            <input type="hidden" name="old_front_image" value="{{@$chiefComplaints->image_front}}">{{@$front_image['basename']}}
                            @if(@$chiefComplaints->image_front == "")
                            @php($required = 'required')
                            @else
                            @php($required = '')
                            @endif
                            <input class="form-control" name="image_front" data-validation="{{$required}}" type="file"  value="{{ @$chiefComplaints->image_front}}">
                        </div> 
                        <div class="form-group mb-4">
                            <label>{{ __('Back Image') }}</label>
                            @if(@$chiefComplaints->image_back)
                            <input type="image" src="{{$chiefComplaints->image_back}}">
                            @endif
                            <input type="hidden" name="old_back_image" value="{{@$chiefComplaints->image_back}}">{{@$back_image['basename']}}
                            @if(@$chiefComplaints->image_back == "")
                            @php($required = 'required')
                            @else
                            @php($required = '')
                            @endif
                            <input class="form-control" name="image_back" data-validation="{{$required}}" type="file"  value="{{@$chiefComplaints->image_back}}">
                        </div> 
                        <div class="form-group mb-4">
                            <label>{{ __('Sort Order') }}</label>
                            <input class="form-control" name="sort_order" data-validation="required|number" type="text" value="{{@$chiefComplaints->sort_order}}">
                        </div> 
                       <!--  <div class="form-group mb-4">
                            <label>{{ __('Extension') }}</label>
                            <input class="form-control" name="extension" data-validation="required" type="text" placeholder="" value="{{@$userData->extension}}">
                        </div>  -->
                    </div>
                    <div class="ibox-footer">
                        <button title="Submit" class="btn btn-primary mr-2" type="submit" name="btn-submit" value="submit">{{__('Submit')}}</button>
                        <!-- <button class="btn btn-outline-secondary" type="reset">Cancel</button> -->
                    </div>
                </form>
            </div>
        </div>
    </div>
</div>

<!-- JS FORM VALIDATION -->

<script src="//ajax.googleapis.com/ajax/libs/jquery/1.10.2/jquery.min.js"></script>
<script src="//cdnjs.cloudflare.com/ajax/libs/jquery-form-validator/2.3.26/jquery.form-validator.min.js"></script>
<script>
  $.validate({
    lang: 'en'
  });
</script>
@endsection

