@extends('physician.layouts.master')
@section('content')
  <?php  $success = false; ?>
    @if (\Session::has('error'))
        <div class="alert alert-danger">
            {!! \Session::get('error') !!}
        </div>
    @endif
    @if (\Session::has('success'))
    <?php $success = true; ?> 
        <div class="alert alert-success">
            {!! \Session::get('success') !!}
        </div>
    @endif
    @if ($errors->any())
          <div class="alert alert-danger">
              <ul>
                  @foreach ($errors->all() as $error)
                      <li>{{ $error }}</li>
                  @endforeach
              </ul>
          </div>
    @endif
    <div class="page-content fade-in-up">
     <div class="row">
        <div class="col-md-12">
            <div class="ibox">
                <form class="form-purple" action="{{ route('physician_edit') }}" method="post" enctype="multipart/form-data">
                    <input type="hidden" name="userId" value="{{@$userData->id}}">
                    <input type="hidden" name="userEmail" value="{{@$userData->email}}">
                    <div class="ibox-head">
                        <div class="ibox-title">{{__('Edit Profile')}}</div>
                    </div>
                    <div class="ibox-body col-md-8">
                        <div class="form-group mb-4">
                            <label>{{ __('Name') }}</label>
                            <input class="form-control" name="name" data-validation1="required" type="text"  value="{{old('name', @$userData->name)}}">
                        </div> 
                        <div class="form-group mb-4">
                            <label>{{ __('First Name') }}</label>
                            <input class="form-control" name="first_name" data-validation1="required" type="text"  value="{{old('first_name',@$userData->first_name)}}">
                        </div> 
                        <div class="form-group mb-4">
                            <label>{{ __('Last Name') }}</label>
                            <input class="form-control" name="last_name" data-validation1="required" type="text"  value="{{old('last_name',@$userData->last_name)}}">
                        </div> 
                        <div class="form-group mb-4">
                            <label>{{ __('Office Phone') }}</label>
                            <input class="form-control" name="office_phone" data-validation1="required|number" type="text" value="{{old('office_phone',@$userData->office_phone)}}">
                        </div> 
                        <div class="form-group mb-4">
                            <label>{{ __('Extension') }}</label>
                            <input class="form-control" name="extension" data-validation1="required|number" type="text"  value="{{@$userData->extension}}">
                        </div> 
                        <div class="form-group mb-4">
                            <label>{{ __('Mobile No') }}</label>
                            <input class="form-control" name="mobile_no" data-validation1="required|number" type="text"  value="{{old('mobile_no',@$userData->mobile_no)}}">
                        </div>  
                         <div class="form-group mb-4">
                            <label>{{ __('Picture') }}</label><br>
                            @if($userData->picture)
                            <input type="hidden" name="oldPicture" value="{{@$userData->picture}}">
                            <img src="{{@$userData->picture}}" width="400px"><br><br>
                            @endif
                            @if(@$userData->picture == "")
                            @php($required = 'required')
                            @else
                            @php($required = '')
                            @endif
                            <input class="form-control" name="picture"  type="file"  value="{{@$userData->picture}}">
                        </div>
                    </div>
                    <div class="ibox-footer">
                        <button title="Submit" class="btn btn-primary mr-2" type="submit" name="btn-submit" value="submit">{{__('Submit')}}</button>
                        <!-- <button class="btn btn-outline-secondary" type="reset">Cancel</button> -->
                    </div>
                </form>
            </div>
        </div>
    </div>
</div>

<!-- JS FORM VALIDATION -->

<script src="//ajax.googleapis.com/ajax/libs/jquery/1.10.2/jquery.min.js"></script>
<script src="//cdnjs.cloudflare.com/ajax/libs/jquery-form-validator/2.3.26/jquery.form-validator.min.js"></script>
<script>
  $.validate({
    lang: 'en'
  });
</script>
@endsection

