<?php
if(env('APP_ENV') == 'production')
{
	URL::forceScheme('https');
}
use Illuminate\Http\Request;

/*
|--------------------------------------------------------------------------
| API Routes
|--------------------------------------------------------------------------
|
| Here is where you can register API routes for your application. These
| routes are loaded by the RouteServiceProvider within a group which
| is assigned the "api" middleware group. Enjoy building your API!
|
*/

Route::middleware('auth:api')->get('/user', function (Request $request) {
    return $request->user();

});

/* Auth */
Route::post('login', ['uses' => 'Api\UserController@login']);
Route::post('startup', ['uses' => 'Api\UserController@startup']);
Route::any('edit-profile', ['uses' => 'Api\UserController@editProfile']);
Route::post('get-profile', ['uses' => 'Api\UserController@getProfile']);
Route::post('get-cheif-complain-types', ['uses' => 'Api\PatientController@getComplaintypes']);
Route::post('get-questions-by-complain-type', ['uses' => 'Api\PatientController@getQuestionByComplainTypes']);
Route::post('search-question', ['uses' => 'Api\PatientController@getQuestionBySearch']);

Route::group(['middleware' => ['OnlyForSurgeon']], function () {

	Route::post('save-patient-narratives', ['uses' => 'Api\PatientController@savePatientNarratives']);
	Route::post('save-narratives-by-patient-id', ['uses' => 'Api\PatientController@saveNarrativesByPatientID']);
	Route::post('pending-patient-narratives', ['uses' => 'Api\PatientController@pendingPatientNarratives']);
	Route::post('patient-narratives-by-patient-id', ['uses' => 'Api\PatientController@getPatientNarrativesByPatientID']);
	Route::post('patient-narratives-details', ['uses' => 'Api\PatientController@patientNarrativesDetails']);
	Route::post('accept-narrative', ['uses' => 'Api\PatientController@acceptNarrative']);
	Route::post('narratives-details', ['uses' => 'Api\PatientController@patientNarrativesBySurgoanID']);

	Route::post('get-questions-by-narrative-id', ['uses' => 'Api\PatientController@getQuestionByNarrativeID']);
	Route::post('update-patient-narratives', ['uses' => 'Api\PatientController@updatePatientNarratives']);
	Route::post('save-surgeon-question', ['uses' => 'Api\PatientController@saveSurgeonQuestion']);
	Route::post('get-patient-complain-detail', ['uses' => 'Api\PatientController@getPatientComplainById']);
	Route::post('get-patient-options-detail', ['uses' => 'Api\PatientController@getPatientOptionsByPatientId']);
	Route::post('approved-patient-narrative', ['uses' => 'Api\PatientController@approvedPatientNarratived']);
	Route::post('patient-complains', ['uses' => 'Api\PatientController@getPatientComplains']);
	Route::post('patient-complains-details', ['uses' => 'Api\PatientController@getPatientComplainsDetails']);
	Route::post('search-question', ['uses' => 'Api\PatientController@searchQuestion']);
	Route::post('save-search-question-options', ['uses' => 'Api\PatientController@saveSearchQuestion']);
	Route::post('get-additional-patient-narrative', ['uses' => 'Api\PatientController@getAdditionalPatientNarrative']);
	Route::post('save-pending-question', ['uses' => 'Api\PatientController@savePendingQuestion']);
	Route::post('delet-additional-info', ['uses' => 'Api\PatientController@deletAdditionalInfo']);



});

