<?php

// use Redirect;
use Illuminate\Support\Facades\Redirect;
/*
|--------------------------------------------------------------------------
| Web Routes
|--------------------------------------------------------------------------
|
| Here is where you can register web routes for your application. These
| routes are loaded by the RouteServiceProvider within a group which
| contains the "web" middleware group. Now create something great!
|
*/

Route::get('test/treeview', ['uses' => '\App\Http\Controllers\TestController@treeView', 'as' => 'tree_view']);

Route::get('logout', ['uses' => '\App\Http\Controllers\Auth\LoginController@logout', 'as' => 'logout']);
Auth::routes();
Route::get('/', function()
{
    return redirect('/login');
});

	// TAMIMI LARAVEL
Route::group(['prefix' => 'admin', 'middleware' => ['auth']], function () {
	Route::middleware(['OnlyForAdmin'])->group(function () 
	{
		
		Route::get('', ['uses' => 'AdminController@index', 'as' => 'admin_dashboard', 'uses' => function () {
		    return redirect::to('admin/users/listing');
		}]);
		
		//ADD, DELETE AND LISTING PUSH USERS ROLE WITH MESSAGE
		Route::get('/users/listing', ['uses' => 'AdminController@usersListing', 'as' => 'admin_users_listing']);
		Route::any('/users/save/{id?}', ['uses' => 'AdminController@saveUsers', 'as' => 'admin_users_save']);
		Route::any('/users/users/ajax', ['uses' => 'AdminController@usersAjax', 'as' => 'admin_users_ajax']);
		Route::get('/users/users/delete/{id}', ['uses' => 'AdminController@deleteUsers', 'as' => 'admin_users_delete']);

		// ADD AND EDIT CLINIC
		Route::any('/clinic/save/{id?}', ['uses' => 'AdminController@saveClinic', 'as' => 'admin_clinic_save']);
		
	});
});

	Route::group(['prefix' => 'physician', 'middleware' => ['auth']], function () {
	Route::middleware(['OnlyForPhysician'])->group(function () {



		Route::get('', ['uses' => '\App\Http\Controllers\physician\PhysicianController@index', 'as' => 'patient_dashboard', 'uses' => function () {
		    return redirect::to('physician/question/listing');
		}]);
		
		//ADD, DELETE AND LISTING PUSH USERS ROLE WITH MESSAGE
		Route::any('/change-password', ['uses' => '\App\Http\Controllers\physician\PhysicianController@change_password', 'as' => 'change_password']);
		Route::get('/dashboard', ['uses' => '\App\Http\Controllers\physician\PhysicianController@index', 'as' => 'dashboard']);
		Route::any('/reset-password', ['uses' => 'ResetPasswordController@resetPassword', 'as' => 'reset_password']);
		Route::any('/profile', ['uses' => '\App\Http\Controllers\physician\PhysicianController@profile', 'as' => 'profile']);
		Route::any('/edit', ['uses' => '\App\Http\Controllers\physician\PhysicianController@editPhysician', 'as' => 'physician_edit']);

		// CHIEF COMPLAINS
		Route::get('/chief-complains/listing', ['uses' => '\App\Http\Controllers\physician\PhysicianController@chiefComplaintsListing', 'as' => 'chief_complains_listing']);
		Route::any('/chief-complains-ajax', ['uses' => '\App\Http\Controllers\physician\PhysicianController@chiefComplaintsAjax', 'as' => 'chief_complains_ajax']);
		Route::any('/chief-complains/save/{id?}', ['uses' => '\App\Http\Controllers\physician\PhysicianController@saveChiefComplaints', 'as' => 'chief_complains_save']);
		Route::get('/chief-complains/delete/{id}', ['uses' => '\App\Http\Controllers\physician\PhysicianController@deleteChiefComplains', 'as' => 'chief_complains_delete']);
		Route::get('/chief-complains/list', ['uses' => '\App\Http\Controllers\physician\PhysicianController@complainTypeList', 'as' => 'chief_complains_list']);
		Route::get('/chief-complains/questions-tree/{id?}', ['uses' => '\App\Http\Controllers\physician\PhysicianController@chiefComplainsTree', 'as' => 'chief_complains_questions_tree']);

		// QUESTIONS
		Route::get('/question/listing', ['uses' => '\App\Http\Controllers\physician\PhysicianController@questionsListing', 'as' => 'questions_listing']);
		Route::any('/question/save/{id?}', ['uses' => '\App\Http\Controllers\physician\PhysicianController@saveQuestions', 'as' => 'save_question']);
		Route::any('/question/duplicate/{id?}', ['uses' => '\App\Http\Controllers\physician\PhysicianController@duplicateUser', 'as' => 'duplicate_user']);
		Route::any('/question/ajax', ['uses' => 'physician\PhysicianController@QuestionsAjax', 'as' => 'Questions_ajax']);
		Route::any('/question/duplicate_questions/{id?}', ['uses' => 'physician\PhysicianController@duplicateQuestionsAjax', 'as' => 'duplicate_questions_ajax']);
		Route::any('/question/delete/{id}', ['uses' => '\App\Http\Controllers\physician\PhysicianController@deleteQuestions', 'as' => 'delete_questions']);
		Route::get('/question/options/list', ['uses' => '\App\Http\Controllers\physician\PhysicianController@questionOptionsList', 'as' => 'question_options_list']);
		Route::get('/question/list', ['uses' => '\App\Http\Controllers\physician\PhysicianController@getMultiselectQuestions', 'as' => 'question_list']);

	
		// QUESTIONS CATEGORIES
		Route::get('/question/categories', ['uses' => 'physician\QuestionCategoriesController@index', 'as' => 'questions_categories']);
		Route::get('/question/categories/listing', ['uses' => 'physician\QuestionCategoriesController@ajaxListing', 'as' => 'questions_categories_listing']);
		Route::any('/question/categories/save/{id?}', ['uses' => 'physician\QuestionCategoriesController@save', 'as' => 'questions_categories_save']);
		Route::get('/question/categories/delete/{id}', ['uses' => 'physician\QuestionCategoriesController@deleteCategories', 'as' => 'questions_categories_delete']);
		
		//TREE VIEW
		Route::get('test/treeview', ['uses' => '\App\Http\Controllers\TestController@treeView', 'as' => 'tree_view']);

		// IMAGE MAPPING
		// Route::get('chief-complains/image-pixel', ['uses' => '\App\Http\Controllers\physician\PhysicianController@imagePixel', 'as' => 'image_pixel']);
		Route::get('chief-complains/image-mapping/{id?}/{imageType?}', ['uses' => 'physician\PhysicianController@imageMapping', 'as' => 'image_map']);
		// Route::get('chief-complains/image-mapping//id/{id}/image_type/{image_type}', ['uses' => 'physician\PhysicianController@imageMapping', 'as' => 'image_map']);
		 
		Route::post('chief-complains/image-mapping-ajax', ['uses' => 'physician\PhysicianController@ImageMappingaAjaxEdit', 'as' => 'image_map_ajax_edit']);
		Route::post('chief-complains/image-mapping-ajax/add', ['uses' => 'physician\PhysicianController@ImageMappingaAjaxAdd', 'as' => 'image_map_ajax_add']);
		Route::any('chief-complains/image-mapping/delete', ['uses' => 'physician\PhysicianController@imageMappingDelete', 'as' => 'image_map_delete']);
		Route::any('pending-questions', ['uses' => 'physician\PhysicianController@pendingQuestions', 'as' => 'pending_questions']);
		Route::any('pending-questions-ajax', ['uses' => 'physician\PhysicianController@pendingQuestionAjax', 'as' => 'pending_questions_ajax']);
		// Route::any('chief-complains/coordinate-exist/{id?}', ['uses' => '\App\Http\Controllers\physician\PhysicianController@isCoordinateExist', 'as' => 'is_coordinate_exist']);

	});
});
