@extends('physician.layouts.master')
@section('content')

  <?php
    $complainId =  session('complainTypeId');
    $parentQuestionId =  session('parentQuestionId');
    $questionoptionId =  session('questionoptionId');
    $questionId =  session('questionId');
    $questionOptionsArray =  session('questionOptionsArray');
    //dd(session()->get( 'QuestionBranchingLogics' ));
    if (empty($QuestionBranchingLogics)) 
    {
      $QuestionBranchingLogics = session()->get( 'QuestionBranchingLogics' ); 
      $questionsArray          = session()->get( 'questionsArray' ); 
    }
    //dd($questionsArray);
  // dd($questionsArray);
   // $finalQuestionOptionsArray =  session('finalQuestionOptionsArray');
   $success = false; ?>
    @if (\Session::has('error'))
        <div class="alert alert-danger">
            {!! \Session::get('error') !!}
        </div>
    @endif
    @if (\Session::has('success'))
    <?php $success = true; ?> 
        <div class="alert alert-success">
            {!! \Session::get('success') !!}
        </div>
    @endif
     @if ($errors->any())
          <div class="alert alert-danger">
              <ul>
                  @foreach ($errors->all() as $error)
                      <li>{{ $error }}</li>
                  @endforeach
              </ul>
          </div>
    @endif
    <style>
        .js-options .mb-8:nth-child(even) {background: #ebebec}
.js-options .mb-8:nth-child(odd) {background: #f7f7f7}


.js-options .mb-8
{
    padding: 10px;
}


        .ibox { margin-bottom: 3px; }
    </style>

   <div class="page-heading">
                <br /><h1 class="page-title">{{$heading}} @if($questions->id)
                <a href="{{route('duplicate_user',$questions->id)}}" class="btn btn-primary pull-right mr-3">Duplicate Question</a>
                @endif</h1> 
                
            <div class="page-content fade-in-up">
                <form class="form-purple" id="questionForm" action="{{ $route }}" method="post" enctype="multipart/form-data">
                    <input type="hidden" name="questionId" value="{{$questions->id}}">
                    <div class="row">
                            <div class="col-md-6">
                                <div class="ibox">
                                        <div class="ibox-head">
                                            <div class="ibox-title">Question Details</div>
                                        </div>
                                        <div class="ibox-body">
                                            <div class="form-group mb-4">
                                                <label>{{ __('Question Category') }}</label>
                                                <select class="form-control" name="category" >
                                                <option value="">- Select -</option>
                                                @if($categories)
                                                    @foreach($categories as $row)
                                                        @if($row->status == 0)
                                                        @php($status = ' (Inactive)')
                                                        @else
                                                        @php($status = '')
                                                        @endif
                                                        <option {{ $questions->category_id == $row->id ? 'selected' :''   }} value="{{$row->id }}" @if(old('category') == $row->id) selected="selected" @endif>{{ $row->title }}{{$status}}</option>
                                                    @endforeach
                                                @endif
                                                </select>
                                            </div>
                                            <div class="form-group mb-4 ">
                                                <label>{{ __('Chief Complain') }}</label>
                                                    <select class="form-control complain_types" name="complain_type_id" >
                                                        <option value="">- Select -</option>
                                                        @if($complain_types)
                                                            @foreach($complain_types as $row)
                                                                @if($row->status == 0)
                                                                @php($status = ' (Inactive)')
                                                                @else
                                                                @php($status = '')
                                                                @endif
                                                                <option {{ $questions->complain_type_id == $row->id ? 'selected' :''   }} value="{{  $row->id}}" @if(old('complain_type_id') == $row->id) selected="selected" @endif>{{ $row->name }}{{$status}}</option>
                                                            @endforeach
                                                        @endif
                                                    </select>
                                            </div>
                                        <div class="form-group mb-4">
                                            <label>{{ __('Question Title') }}</label>
                                            <input class="form-control" name="name" type="text"  value="{{old('name', $questions->name)}}">
                                        </div>
                                            <div class="form-group mb-4">
                                              <label>{{ __('Is Multiselect') }}</label>
                                                <div class="mt-1">
                                                  <label class="radio radio-inline radio-grey radio-primary">
                                                  <input class="js-is-multiselect" type="checkbox" name="is_multiselect" value="1" @if(old('is_multiselect', @$isMultiselect) == '1') checked @endif>
                                                  <span class="input-span"></span>multiselect</label>
                                                </div>
                                            </div>
                                            <div class="form-group mb-4 js-prefix">
                                                <label>{{ __('Prefix') }}</label>
                                                <input class="form-control "  type="text" name="prefix" value="{{@$prefix}}" >
                                            </div>
                                             <div class="form-group mb-4 js-postfix">
                                                  <label>{{ __('Postfix') }}</label>
                                                  <input class="form-control " type="text" name="postfix" value="{{@$postfix}}" >
                                            </div>
                                             <div class="form-group mb-4">
                                              <label>{{ __('Select Type') }}</label>
                                                <div class="mt-1">
                                                  <label class="radio radio-inline radio-grey radio-primary">
                                                  <input class="js-image-only" type="checkbox" name="image_only" value="1" @if(old('is_multiselect', @$imageOnly) == '1') checked @endif>
                                                  <span class="input-span"></span>Image Only</label>
                                                   <label class="radio radio-inline radio-grey radio-primary">
                                                  <input class="js-option-only" type="checkbox" name="option_only" value="1" @if(old('is_multiselect', @$optionOnly) == '1') checked @endif>
                                                  <span class="input-span"></span>Options Only</label>
                                                   <label class="radio radio-inline radio-grey radio-primary">
                                                  <input class="js-image-and-options" type="checkbox" name="image_and_options" value="1" @if(old('is_multiselect', @$imageAndOptions) == '1') checked @endif>
                                                  <span class="input-span"></span>Image And Options</label>
                                                </div>
                                            </div>
                                              <div class="form-group mb-4 js-question-image">
                                              @if(!@$questionImage)
                                              <label>{{ __('Image') }}</label><br>
                                              @endif
                                              @if(@$questionImage)
                                                <label>{{ __('select option for image') }}</label>
                                                <select class="form-control js-option-text" data-validation="required">
                                                @foreach($questionOptions as $row)
                                                    <option class="dropdown-item" value="{{ $row->title }}" data-option-text-id="{{$row->id}}">{{ $row->title }}
                                                    </option>                                   
                                                @endforeach 
                                                </select>
                                              @endif
                                              @if(@$questionImage)
                                              <img src="{{@$questionImage}}" class="annotatable"> 
                                              @endif

                                              <input type="hidden" name="old_front_image" value="{{@basename($questionImage)}}" >
                                              <input class="form-control" name="image_front"  type="file"  value="" >
                                            </div> 
                                     <div class="js-options">

                                            @if($questionOptionsArray)
                                              @php($questionOptions = $questionOptionsArray)
                                            @endif

                                            @if($questionOptions)
                                                @foreach($questionOptions as $row)
                                                    <div class="mb-8">
                                                        <input type="hidden" name="old_questions_opt_id[]" value="{{ @$row->id }}">
                                                        <div class="form-group mb-4">
                                                            <label>{{ __('Option Text') }}</label>
                                                            <input class="form-control" value="{{ $row->title }}" name="option_text[]"  type="text" placeholder="" >
                                                        </div> 
                                                        <div class="form-group mb-4">
                                                            <label>{{ __('Option Order') }}</label>
                                                            <input class="form-control" value="{{ $row->sort_order }}" name="option_order[]"  type="number" placeholder="" >
                                                        </div> 
                                                        <div class="form-group mb-4">
                                                            <label>{{ __('Option Narrative Text') }}</label>
                                                            <input class="form-control" value="{{ $row->narrative_text }}" name="option_narrative_text[]"  type="text" placeholder="" >
                                                        </div> 
                                                        <div class="form-group mb-4">
                                                            <label>{{ __('Require Input Field') }}</label>
                                                            <select class="form-control" name="option_required_input[]" data-validation="required">
                                                                <option  {{ $row->required_input == config('constants.CONSTANT_REQUIRED_INPUT_INACTIVE') ? 'selected' :''   }}  value="{{config('constants.CONSTANT_REQUIRED_INPUT_INACTIVE')}}">No</option>
                                                                <option  {{ $row->required_input == config('constants.CONSTANT_REQUIRED_INPUT_ACTIVE') ? 'selected' :''   }}  value="{{config('constants.CONSTANT_REQUIRED_INPUT_ACTIVE')}}">Yes</option>
                                                            </select>
                                                        </div> 
                                                        <div class="form-group mb-4">
                                                            <label>{{ __('Require Input Field Label') }}</label>
                                                            <input class="form-control" value="{{ $row->required_input_label }}" name="option_required_input_label[]"  type="text" >
                                                        </div> 
                                                        <div class="form-group mb-4">
                                                            <label>{{ __('Input Field Rules') }}</label>
                                                            <input class="form-control opt-rules"  name="question_option_rules[]" value="{{ @$row->required_input_rules }}">
                                                            <span>required|min-10|max-10|numeric</span>
                                                        </div> 
                                              <div class="form-group mb-4">
                                                            <label>{{ __('Multiselect Text') }}</label>
                                                            <input class="form-control "  name="single_line_text[]" value="{{@$row->single_line_text}}">
                                                        </div>           
                                                        <div class="form-group mb-4">
                                                            <div class="icon-container">
                                                                <a href="javascript:void(0)" class="js-remove-option btn-outline-danger"><span class="ti-close"></span><small><span class="icon-name"> Remove Option</span></small></a>
                                                            </div>
                                                        </div>  
                                                         <hr>
                                                    </div>
                                                @endforeach
                                            @endif
                                     </div>
                                    <div class="form-group mb-4">
                                        <div class="icon-container">
                                            <a href="javascript:void(0)" class="js-add-option btn-outline-success"><span class="ti-plus"></span><small><span class="icon-name"> Add Option</span></small></a>
                                        </div>
                                    </div>
                                    
                                    <div class="form-group mb-4">
                                        <label>{{ __('Status') }}</label>
                                        <select class="form-control" name="status" data-validation="required">
                                            <option  value="1" {{ $questions->status == config('constants.CONSTANT_STATUS_ACTIVE') ? 'selected' :''   }} >Active</option>
                                            <option  value="0" {{ $questions->status == config('constants.CONSTANT_STATUS_INACTIVE') ? 'selected' :''   }}>Inactive</option>
                                        </select>
                                    </div> 
                                    </div> 
                                    <div class="ibox-footer">
                                        <button title="Submit" class="btn btn-primary mr-2 btn-submit" type="submit" name="btn-submit" value="submit">{{__('Submit')}}</button>
                                        <!-- <button class="btn btn-outline-secondary" type="reset">Cancel</button> -->
                                    </div>
                                </div>
                            </div>
                            <div class="col-md-6">
                              <div class="js-question-branching-logic">
                                  @if($QuestionBranchingLogics)
                                    @foreach($QuestionBranchingLogics as $val)
                                      <div class="ibox ">
                                          <div class="ibox-head">
                                              <div class="ibox-title">Question Branching Logic</div>
                                              <div class="icon-container">
                                                  <a href="javascript:void(0)" class="js-remove-parent-question  btn-outline-danger"><small><span class="ti-close"></span></small><span class="icon-name" ></span></a>
                                              </div>
                                          </div>
                                          <div class="ibox-body" >
                                              <div class="form-group mb-4 ">
                                                <label>{{ __('Show Multiselect') }}</label>
                                                  <div class="mt-1">
                                                    <label class="radio radio-inline radio-grey radio-primary">
                                                    <input class="js-show-multiselect js-multiselect"  type="checkbox" name="show_multiselect[]" value="1" @if(old('show_multiselect', @$val['is_multiselect']) == '1') checked @endif>
                                                    <span class="input-span"></span>multiselect</label>
                                                  </div>
                                              </div>
                                           
                                              <div class="js-question-dropdown">
                                                  <div class="form-group mb-4">
                                                      <label>Parent Question <img src="https://i.gifer.com/ZZ5H.gif" class="loader" id="parentQuestionAjaxId"></label>
                                                      <select class="form-control related_question " name="parent_question_id[]" >
                                                           <option value="">- Select -</option>
                                                           <?php
                                                             $parentQuestionId = $val['parent_question_id'];
                                                             $val['is_multiselect'] = isset($val['is_multiselect']) ? $val['is_multiselect'] : null;
                                                            ?>
                                                            
                                                            @if($questionsArray && $val['is_multiselect'] == config('constants.CONSTANT_STATUS_INACTIVE'))

                                                              @foreach($questionsArray as $row)
                                                                  <option {{  $row['id'] == $parentQuestionId ? 'selected' :'' }}  value="{{ $row['id'] }}" >{{ $row['name'] }}</option>                                   
                                                              @endforeach 
                                                            @endif

                                                            @if($val['is_multiselect'] == config('constants.CONSTANT_STATUS_ACTIVE'))
                                                              @foreach($questionsArray as $row)
                                                                  @if($row['is_multiselect'] == config('constants.CONSTANT_STATUS_ACTIVE'))
                                                                  <option {{  $row['id'] == $parentQuestionId ? 'selected' :'' }}  value="{{ $row['id'] }}" >{{ $row['name'] }}</option>          
                                                                  @endif                         
                                                              @endforeach                                 
                                                            @endif
                                                      </select>
                                                  </div>
                                              </div>
                                              <div class="js-question-option-dropdown">
                                                  <div class="form-group mb-4 ">
                                                      <label>Options For Parent Question <img src="https://i.gifer.com/ZZ5H.gif" class="loader" id="questionOptionAjaxId"></label>
                                                      <select class="form-control jsSelectBox" name="question_option_id[]" >
                                                          <option value="">- Select -</option>
                                                          <?php
                                                              $parentQuestionOptions = $question_model->getQuestionOptionsArrayByParentQuestion($val['parent_question_id']);
                                                              $questionoptionId =  $val['parent_question_option_id'];
                                                            ?> 
                                                          @if($parentQuestionOptions)
                                                              @foreach($parentQuestionOptions as $row)
                                                                  <option {{  $questionoptionId ==  $row['id'] ? 'selected' :''   }}  value="{{  $row['id'] }}">{{ $row['title'] }}</option>
                                                              @endforeach                                    
                                                          @endif
                                                      </select>
                                                  </div>
                                              </div>
                                          </div>
                                      </div>
                                    @endforeach
                                @endif
                              </div>
                             
                              <div class="ibox-body js-add-more">
                                <div class="icon-container">
                                    <a href="javascript:void(0)" class="js-add-branch btn-outline-success"><span class="ti-plus"></span><small><span class="icon-name"> Add More</span></small></a>
                                </div>
                              </div>
                            </div>

                            </div>
                    </div>
                    @if ($duplicateQuestionsCount > 0)

                    <br />
                    <div class="row">
                        <div class="col-md-12">
                          <div class="ibox">
                                <div class="ibox-head">
                                     <div class="ibox-title">Duplicate Questions</div>
                                </div>
                                <div class="ibox-body">
                                    <table
                                      class="table table-bordered table-hover" 
                                      id="duplicate_questions" 
                                      data-source = "{{ route('duplicate_questions_ajax',$questions->id) }}"
                                      data-source = "{{ $questions->id }}"
                                      data-cols = ",,,"
                                      data-search = "false"
                                      >
                                          <thead class="thead-default thead-lg">
                                               <tr>
                                                  <th width="5%">ID</th>
                                                  <th width="30%">Title</th>
                                                  <th width="30%">Options</th>
                                                  <th width="5%">Actions</th>


                                              </tr>
                                          </thead>
                                      </table>
                                </div>
                        </div>
                      </div>
                      @endif
                    </div>
                </form>
                <div class="js-options-controll" style="display: none;">
                    <div class="mb-8">
                        <input type="hidden" name="old_questions_opt_id[]" value="">
                        <div class="form-group mb-4">
                            <label>{{ __('Option Text') }}</label>
                            <input class="form-control" name="option_text[]"  type="text"  >
                        </div> 
                        <div class="form-group mb-4">
                            <label>{{ __('Option Order') }}</label>
                            <input class="form-control" name="option_order[]" type="number" >
                        </div> 
                        <div class="form-group mb-4">
                            <label>{{ __('Patient Narrative Text For This Option') }}</label>
                            <input class="form-control" name="option_narrative_text[]"  type="text" >
                        </div> 
                        <div class="form-group mb-4">
                            <label>{{ __('Require Input Field') }}</label>
                            <select class="form-control" name="option_required_input[]" >
                                <option  value="{{config('constants.CONSTANT_REQUIRED_INPUT_INACTIVE')}}">No</option>
                                <option  value="{{config('constants.CONSTANT_REQUIRED_INPUT_ACTIVE')}}">Yes</option>
                            </select>
                        </div> 
                        <div class="form-group mb-4">
                            <label>{{ __('Require Input Field Label') }}</label>
                            <input class="form-control" name="option_required_input_label[]"  type="text" >
                        </div> 
                        <div class="form-group mb-4">
                            <label>{{ __('Input Field Rules') }}</label>
                            <input class="form-control opt-rules"  name="question_option_rules[]" >
                            <span>required|min-10|max-10|numeric</span>
                        </div> 
                        <div class="form-group mb-4">
                            <label>{{ __('Single Line Text') }}</label>
                            <input class="form-control "  name="single_line_text[]" >
                        </div> 
                        <div class="form-group mb-4">
                            <div class="icon-container">
                                <a href="javascript:void(0)" class="js-remove-option  btn-outline-danger"><small><span class="ti-close"></span></small><span class="icon-name" ><small> Remove Option</small></span></a>
                            </div>
                        </div>  
                    </div> 
                </div>


             

                <div class="js-question-controll" style="display: none;">
                    <div class="ibox">
                        <div class="ibox-head">
                              <div class="ibox-title">Question Branching Logic</div>
                              <div class="icon-container">
                                  <a href="javascript:void(0)" class="js-remove-parent-question  btn-outline-danger"><small><span class="ti-close"></span></small><span class="icon-name" ></span></a>
                              </div>
                        </div>
                        <div class="ibox-body" >
                                <div class="form-group mb-4">
                                  <label>{{ __('Show Multiselect') }}</label>
                                    <div class="mt-1">
                                      <label class="radio radio-inline radio-grey radio-primary">
                                      <input class="js-show-multiselect js-multiselect" type="checkbox" name="show_multiselect[]" value="1" >
                                      <span class="input-span"></span>multiselect</label>
                                    </div>
                                </div>
                            <div class="js-question-dropdown">
                                <div class="form-group mb-4">
                                    <label>Parent Question <img src="https://i.gifer.com/ZZ5H.gif" class="loader" id="parentQuestionAjaxId"></label>
                                    <select class="form-control related_question js-parent-question" name="parent_question_id[]" >
                                         <option value="">- Select -</option>
                                    </select>
                                </div>
                            </div>
                            <div class="js-question-option-dropdown">
                                <div class="form-group mb-4 ">
                                    <label>Options For Parent Question <img src="https://i.gifer.com/ZZ5H.gif" class="loader" id="questionOptionAjaxId"></label>
                                    <select class="form-control jsSelectBox"  name="question_option_id[]" >

                                        <option value="">- Select -</option>
                                       
                                    </select>
                                </div>
                            </div>
                        </div>
                    </div> 
                </div>
                
            </div>

<!-- JS FORM VALIDATION -->

<script src="//ajax.googleapis.com/ajax/libs/jquery/1.10.2/jquery.min.js"></script>
<script src="//cdnjs.cloudflare.com/ajax/libs/jquery-form-validator/2.3.26/jquery.form-validator.min.js"></script>
<script>
  $.validate({
    lang: 'en'
  });
    
    
 
  jQuery(document).ready(function($) 
  {
      var image_only = $(".js-image-only").is(':checked') ;
      var option_only = $(".js-option-only").is(':checked') ;
      var image_and_option__only = $(".js-image-and-options").is(':checked') ;
      if (image_only == true) 
      {
        $('.js-question-image').show();
      }
      else if (option_only == true) 
      {
        $('.js-question-image').hide();
      }
      else if (image_and_option__only == true) 
      {
        $('.js-question-image').show();
      }
      else
      {
        $('.js-question-image').hide();
      }
  });
  
  $(".btn-submit").click(function(){
    $(".related_question option").each(function(){
    });
  });
    
 $(".js-image-only").click(function(){

  var image_only = $(".js-image-only").is(':checked') ;
  if (image_only == true) 
  {
     $('.js-question-image').show();
  }
  else
  {
    $('.js-question-image').hide();
  }
    
  });
  
    $(".js-option-only").click(function(){

      var image_only = $(".js-option-only").is(':checked') ;
      if (image_only == true) 
      {
         $('.js-question-image').hide();
      }
      else
      {
        if ($(".js-image-only").is(':checked') == true) 
        {
          $('.js-question-image').show();
        }
        else if($(".js-image-and-options").is(':checked') == true)
        {
          $('.js-question-image').show();
        }
        else
        {
          $('.js-question-image').hide();
        }
      }
    
    });
    
     $(".js-image-and-options").click(function(){

      var image_only = $(".js-image-and-options").is(':checked') ;
      if (image_only == true) 
      {
         $('.js-question-image').show();
      }
      else if($(".js-image-only").is(':checked') == true)
      {
        $('.js-question-image').show();
      }
      else
      {
        $('.js-question-image').hide();
      }
    
     });

    $( window ).load(function() {
    var multiselectChecked = $(".js-is-multiselect").is(':checked') ;
    if (!multiselectChecked) 
    {
      $(".js-postfix").hide();
      $(".js-prefix").hide();
    }
  });
   
  $(".js-is-multiselect").click(function() 
    {
      var is_multiselect = $(".js-is-multiselect").is(':checked') ;
      if (is_multiselect) 
      {
          $(".js-postfix").show();
          $(".js-prefix").show();
      }
      else
      {
          $(".js-postfix").hide();
          $(".js-prefix").hide();
      }
  });

  $('.js-add-option').click(function()
  {
      $('.js-options').append($('.js-options-controll').html())
  });
  $('body').delegate('.js-remove-option','click',function() 
  {
      $(this).closest('.mb-8').remove();
  });
  $('body').delegate('.related_question','change',function()
  {  
    $(this).parents('.ibox-body').addClass('active'); 

    updateOptionListElement(html='');

    if($(this).val()!='')
    {
      $('#questionOptionAjaxId').addClass('is--loading');

        $.ajax(
        {
            type:"GET",
            url: "{{ route('question_options_list') }}",
            data:
            {
                question_id:$(this).val(),
                _token:"{{ csrf_token() }}"
            },
            success: function(result)
            {   
                result = $.parseJSON(result);
                if(result.data)
                {
                    let html = "<option value=''>- Select -</option>";
                    $(result.data).each(function( key,row ) 
                    {
                       html += "<option value='"+row.id+"'>"+row.title+"</option>";
                    });
                    $('.ibox-body.active').find('.jsSelectBox').html(html);
                    $('.ibox-body.active').removeClass('active');
                    // updateOptionListElement(html);
                    $('#questionOptionAjaxId').removeClass('is--loading');
                }
            }
        }); 
    }
      
  });

   $('body').delegate('.js-show-multiselect','change',function()
  {  
    var myClass = Math.random().toString(36).substring(2, 15);
    $(this).parents('.ibox-body').addClass(myClass); 
    
    if($('.ibox-body.'+myClass).find('.js-show-multiselect').is(':checked'))
    {
      $('.js-show-multiselect').addClass('is--loading');
        $.ajax(
        {
            type:"GET",
            url: "{{ route('question_list') }}",
            data:
            {
                complain_type_id:$('.complain_types').val(),
                _token:"{{ csrf_token() }}"
            },
            success: function(result)
            {   
                result = $.parseJSON(result);
                if(result.data)
                {
                    let html = "<option value=''>- Select -</option>";
                    $(result.data).each(function( key,row ) 
                    {
                    
                       html += "<option value='"+row.id+"'>"+row.name+"</option>";
                    });
                    console.log(html, $('.ibox-body.'+myClass));
                    $('.ibox-body.'+myClass).find('.related_question').html(html);
                    $('.ibox-body.'+myClass).removeClass(myClass);
                    $('.ibox-body.'+myClass).find('.jsSelectBox').val('');
                    // $('#parentQuestionAjaxId').removeClass('is--loading');
                }
                else
                {
                    $('.ibox-body.'+myClass).removeClass(myClass);
                }
            }
        }); 
    }
    else if($(this).attr('checked', false))
    {
      $('.ibox-body.'+myClass).removeClass(myClass);
      var target = $(this).parents('.ibox-body').find('.related_question');
      updateParentQuestionControl(target);
    }
      
  });

  $('.complain_types').change(function()
  {   
    $('.jsSelectBox').html('<option> -Select-</option>');
      
      updateQuestionListElement(html='');
     
      updateParentQuestionControl(target="");
     
  });

  // $('.js-show-multiselect').change(function()
  // {   
  //   $('.jsSelectBox').html('<option> -Select-</option>');
      
  //     updateQuestionListElement(html='');
     
  //     updateParentQuestionControl(target="");
     
  // });

  function updateQuestionListElement(html)
  {
    $('.js-question-dropdown select').html(html);
  }

  function updateOptionListElement(html)
  {
      $('.ibox-body.active .js-question-option-dropdown select').html(html);
  }

  function updateParentQuestionControl(target='')
  {   
      // if($(".js-show-multiselect").is(':checked')) 
      // {
      //   var route = "{{ route('question_list') }}";
      // }
      // else
      // {
      //   var route = "{{ route('chief_complains_list') }}";
      // }  
      if($('.complain_types').val()!='')
      {
        $('#parentQuestionAjaxId').addClass('is--loading');
        $.ajax(
        {
            type:"GET",
            url: "{{ route('chief_complains_list') }}",
            data:
            {
                complain_type_id:$('.complain_types').val(),
                _token:"{{ csrf_token() }}"
            },
            success: function(result)
            {   
                result = $.parseJSON(result);
                if(result.data)
                {
                  let html = "<option value=''>- Select -</option>";
                  $(result.data).each(function( key,row ) 
                  {
                    html += "<option value='"+row.id+"'>"+row.name+"</option>";
                  });
                  if(target) 
                  {
                    $(target).html(html)
                  }   
                  else
                  {
                    updateQuestionListElement(html);
                  }
                  $('#parentQuestionAjaxId').removeClass('is--loading');
                }
            }
        }); 
      }
  }

  // $('.js-show-multiselect').click(function(){
   
  //     updateParentQuestionControl(target="");
  // });

  $('.js-add-branch').click(function()
  {
    $('.js-question-branching-logic').append($('.js-question-controll').html());
    addParentQuestionInControll()
  });
  $('body').delegate('.js-remove-parent-question','click',function() 
  {
      $(this).closest('.ibox').remove();
  });
  $('#questionForm').submit(function(e)
  {

  });
    <?php 
    // TODO's
    // AJAX CAll Multiple will fix this later ?>
  function addParentQuestionInControll()
  { 
    index = $('.related_question').length;
    target = ".related_question:eq("+(index-2)+")";
    updateParentQuestionControl(target)
  }

  var QuestionBranchingLogics = "{{  is_array($QuestionBranchingLogics) ? '1' :'0'   }}";
  if(QuestionBranchingLogics == 0) 
  {
    $('.js-add-branch').trigger('click')
  }

  
</script>

@section('scripts')
<script>
  DataTable.initDataTable('#duplicate_questions');
</script>
@endsection
<!-- <script 
@endsection

    