<?php

namespace App\Http\Controllers;
use Illuminate\Http\Request;
use App\Helpers\CommonHelper;
use App\Helpers\WpAPI;
use App\User;
use Validator;
use Hash;
use Config;
use Illuminate\Support\Facades\DB;
use App\Http\Controllers\Controller;
use Corcel\Model\Post as WordpressPost;
use Carbon\Carbon;
use Illuminate\Mail\Message;
use Illuminate\Support\Facades\Password;


use Illuminate\Support\Facades\File;

use App\Models\LogsSAML;

use Auth;
use Mail;

class SamlController extends Controller
{
    function samlLogin(Request $request)
    {
        $ipAddress = $request->ip();

        $samlId = 'TAMIMI_WEB_809707f0030a5d00620c9d9df97f627afe9dcc24_' . uniqid();
        //-->$samlIssueInstantDate = date('Y-m-d') . 'T12:40:34.659Z';
        $samlIssueInstantDate = '2019-03-26T12:40:34.659Z';

        $samlCallBackURL = env('SITE_URL').'saml/callback';
        $samlEntityURL = 'https://www.tamimi.com'; //-->env('SITE_URL');

        $xml = '<?xml 
version="1.0" 
encoding="UTF-8"?>
<samlp:AuthnRequest 
    xmlns:samlp="urn:oasis:names:tc:SAML:2.0:protocol" 
    AssertionConsumerServiceURL="'. $samlCallBackURL .'" 
    Destination="https://adfs.tamimi.com/adfs/ls/" 
    ID="'. $samlId .'" 
    IssueInstant="'. $samlIssueInstantDate .'" 
    ProtocolBinding="urn:oasis:names:tc:SAML:2.0:bindings:HTTP-POST" 
    Version="2.0">
    <saml:Issuer 
        xmlns:saml="urn:oasis:names:tc:SAML:2.0:assertion">'. $samlEntityURL .'
    </saml:Issuer>
</samlp:AuthnRequest>';

        $link = 'https://adfs.tamimi.com/adfs/ls/?SAMLRequest=' . urlencode(base64_encode(gzdeflate($xml)));

        $logData = array();

        $logData['saml_id']      = $samlId;
        $logData['request_link'] = $link;
        $logData['request_time'] = date('Y-m-d H:i:s');
        $logData['ip_address']   = $ipAddress;
        $logData['request_xml']  = $xml;
        
        LogsSAML::updateOrCreate(['id' => 0], $logData);

        return redirect($link);
    }

    function samlLoginViaMobile(Request $request)
    {
        $ipAddress = $request->ip();

        $samlId = 'TAMIMI_APP_809707f0030a5d00620c9d9df97f627afe9dcc24_' . uniqid();
        //-->$samlIssueInstantDate = date('Y-m-d') . 'T12:40:34.659Z';
        $samlIssueInstantDate = '2019-03-26T12:40:34.659Z';

        $samlCallBackURL = env('SITE_URL').'saml/callback';
        $samlEntityURL = 'https://www.tamimi.com'; //-->env('SITE_URL');

        $xml = '<?xml 
version="1.0" 
encoding="UTF-8"?>
<samlp:AuthnRequest 
    xmlns:samlp="urn:oasis:names:tc:SAML:2.0:protocol" 
    AssertionConsumerServiceURL="'. $samlCallBackURL .'" 
    Destination="https://adfs.tamimi.com/adfs/ls/" 
    ID="'. $samlId .'" 
    IssueInstant="'. $samlIssueInstantDate .'" 
    ProtocolBinding="urn:oasis:names:tc:SAML:2.0:bindings:HTTP-POST" 
    Version="2.0">
    <saml:Issuer 
        xmlns:saml="urn:oasis:names:tc:SAML:2.0:assertion">'. $samlEntityURL .'
    </saml:Issuer>
</samlp:AuthnRequest>';

        $link = 'https://adfs.tamimi.com/adfs/ls/?SAMLRequest=' . urlencode(base64_encode(gzdeflate($xml)));

        $logData = array();

        $logData['saml_id']      = $samlId;
        $logData['request_link'] = $link;
        $logData['request_time'] = date('Y-m-d H:i:s');
        $logData['ip_address']   = $ipAddress;
        $logData['request_xml']  = $xml;
        
        LogsSAML::updateOrCreate(['id' => 0], $logData);

        return redirect($link);
    }

    public function samlCallback(Request $request)
    {
        $SAMLResponse = @$_REQUEST['SAMLResponse'];

        if($SAMLResponse)
        {
            $SAMLResponse = base64_decode($SAMLResponse);

            if($SAMLResponse)
            {
                $xmlstring = $SAMLResponse;

                $xml = simplexml_load_string($xmlstring, "SimpleXMLElement");

                $samlInfo = array();

                foreach($xml->attributes() as $a => $b)
                {
                    $a = (string) $a;
                    $b = (string) $b;

                    $samlInfo[$a] = $b;
                }

                foreach($xml->Assertion->AttributeStatement->Attribute as $k => $v)
                {
                    foreach($v->attributes() as $a => $b)
                    {
                        $b = (string) $b;
                        $attributeValue = (string) $v->AttributeValue;
                        
                        $samlInfo[$b] = $attributeValue;
                    }
                }

                /* 
                Array
                        (
                            [ID] => _a6499edc-2c0a-4f90-998d-6b1bd8f153a6
                            [Version] => 2.0
                            [IssueInstant] => 2019-03-27T07:44:05.211Z
                            [Destination] => https://tamimi-app.theprojectstagingserver.com/saml/callback
                            [Consent] => urn:oasis:names:tc:SAML:2.0:consent:unspecified
                            [InResponseTo] => TAMIMI_APP_809707f0030a5d00620c9d9df97f627afe9dcc24_7
                            [Email] => adfs.test@tamimi.com
                            [FirstName] => Create Media
                            [LastName] => ADFS Test
                            [UserName] => adfs.test
                        )

                */

                $samlId     = @$samlInfo['InResponseTo'];

                if($samlId)
                {
                    $email      = @$samlInfo['Email'];
                    $firstName  = @$samlInfo['FirstName'];
                    $lastName   = @$samlInfo['LastName'];

                    $logData = array();

                    $logData['response']            = $SAMLResponse;
                    $logData['response_email']      = $email;
                    $logData['response_first_name'] = $firstName;
                    $logData['response_last_name']  = $lastName;
                    $logData['response_time']       = date('Y-m-d H:i:s');
                    
                    LogsSAML::updateOrCreate(['saml_id' => $samlId], $logData);

                    $info = array('first_name' => $firstName, 'last_name' => $lastName);
                    CommonHelper::signupEmployee($email, $info);

                    $link = 'https://www.tamimi.com/atcoapp/saml/login-data?email='.$email.'&sid='.$samlId.'&do_close=1';

                    return redirect($link);

                    /*

                    echo 'You are Logged-In as: ';
                    
                    echo '<br /><br />';
                    echo '<strong>Name:</strong> ' . $firstName . ' '. $lastName;

                    echo '<br /><br />';
                    echo '<strong>Email:</strong> ' . $email;

                    exit;
                    */  
                }
            }

            header ("Content-Type:text/xml");
            echo $SAMLResponse;
            exit;
        }

        echo 'Access Denied!';
        exit;
    }

    public function samlLoginData(Request $request)
    {
        echo 'Loading...';
        exit;
    }
}
