<?php



namespace App\Models;



use Illuminate\Database\Eloquent\Model;

use Illuminate\Support\Facades\Config;

class Questions extends Model

{

    protected $table = 'questions';

    

    public $timestamps = true;

    

    protected $fillable = ['name','complain_type_id','category_id','question_option_id','status','added_by_id','sort_order','department_id','is_multiselect','prefix','postfix'];





	public function question_category()

    {

        return $this->hasOne('App\Models\QuestionCategories', 'id', 'category_id');

    }



    public function cheif_complain_types()

    {

        return $this->hasOne('App\Models\CheifComplainTypes', 'id', 'complain_type_id');

    }



    public function getQuestionOptions($questionId)

    {

    	return QuestionOptions::where('question_id', $questionId)

    	                      ->orderBy('sort_order', 'ASC')

    	                      ->get();

    }



    public function getQuestionByParentQuestionOption($questionId, $questionOptionId)

    {

    	return $this->where('parent_question_id', $questionId)

    		   		->where('question_option_id', $questionOptionId)

    		   		->first();

    }



    public function getQuestionsArrayByComplainType($complainTypeId=0, $questionId=0)

    {

        //dd($complainTypeId);



        if($questionId)

        {

             return $this->where('complain_type_id', $complainTypeId)->where('id','<>',$questionId)->get()->toArray();

        }

        else

        {

             return $this->where('complain_type_id', $complainTypeId)->get()->toArray();

        }



       

    }



    public function getQuestionOptionsArrayByParentQuestion($ParentQuestionId=0)

    {   

        $questions = $this->find($ParentQuestionId);

        if ($questions) 

        {

            if($questions->status==config('constants.CONSTANT_STATUS_ACTIVE'))

            {

                return  QuestionOptions::where('question_id', $ParentQuestionId)->get()->toArray();

            }

            else

            {

                return false;

            }

        }

        



    }

}