@extends('physician.layouts.master')
@section('content')
  <?php $success = false; ?>
    @if (\Session::has('error'))
        <div class="alert alert-danger">
            {!! \Session::get('error') !!}
        </div>
    @endif
    @if (\Session::has('success'))
    <?php $success = true; ?> 
        <div class="alert alert-success">
            {!! \Session::get('success') !!}
        </div>
    @endif
<div class="page-content fade-in-up">
    <div class="ibox">
        <div class="ibox-body">
            <h5 class="font-strong mb-4">Question Categories</h5>
                <table
                    class="table table-bordered table-hover" 
                    id="questionsCategories" 
                    data-source = "{{ route('questions_categories_listing') }}"
                    data-cols = ",,"
                    data-search = "true"
                    >
                    <thead class="thead-default thead-lg">
                         <tr>
                            <!-- <th width="20%">Category Id</th> -->
                            <th width="30%">Title</th>
                            <th width="30%">Sort Order</th>
                            <th width="10%">Actions</th>
                        </tr>
                    </thead>
                </table>
        </div>
    </div>
</div>

        <!-- END PAGE CONTENT-->
@endsection

@section('scripts')
<script>
    DataTable.initDataTable('#questionsCategories');
</script>
@endsection