@extends('admin.layouts.master')
@section('content')
  <?php $success = false; ?>
    @if (\Session::has('error'))
        <div class="alert alert-danger">
            {!! \Session::get('error') !!}
        </div>
    @endif
    @if (\Session::has('success'))
    <?php $success = true; ?> 
        <div class="alert alert-success">
            {!! \Session::get('success') !!}
        </div>
    @endif
<div class="page-content fade-in-up">
    <div class="ibox">
        <div class="ibox-body">
            <h5 class="font-strong mb-4">{{__('Chief Complaints')}}</h5>
                <table
                    class="table table-bordered table-hover" 
                    id="notificationsListing" 
                    data-source = "{{ route('physician_Ajax') }}"
                    data-cols = ",,,">
                    <thead class="thead-default thead-lg">
                         <tr>
                            <th width="20%">Name</th>
                            <th width="50%">Front Image</th>
                            <th width="50%">Back Image</th>
                            <th width="20%">Created</th>
                            <th width="10%">Actions</th>
                        </tr>
                    </thead>
                </table>
        </div>
    </div>
</div>

        <!-- END PAGE CONTENT-->
@endsection

@section('scripts')
<script>
    DataTable.initDataTable('#notificationsListing');
</script>
@endsection