$(document).ready(function () {
  $('.js-add-point').click(function (e) {
    e.preventDefault();
    let pointsData = generatePointData();
    if(pointsData.length < questionOptionsUnique)
    { $('.js-point-img-container').append('<div class="img-point js-point-drag" data-id="" data-option_id=""  data-option_text=""><div class="dragger-tooltip"></div><div class="delete-tooltip">X</div></div>');
      addJsPointDrag();
    }
    else
    {
      alert('Option Limit Exceed');
    }
  });
});

function addJsPointDrag() {
  $(".js-point-drag").each(function () {
    if (!$(this).hasClass('js-point-drag--added')) {
      $(this).draggable({
        containment: "parent"
      });
    }
  });
  var numItems = $('.js-point-img-container > div').length;
}

function generatePointData() {
  var pointsData = [];
  var $thisContainer = $('.js-point-img-container');
  $('.js-point-img-container .js-point-drag').each(function () {
    var thisLeft = +$(this).css('left').split('px')[0];
    var thisTop = +$(this).css('top').split('px')[0];
    var thisWidth = $thisContainer.width();
    var thisHeight = $thisContainer.height();
    var thisLeftPercent = thisLeft / thisWidth * 100;
    var thisTopPercent = thisTop / thisHeight * 100;
    var optionId = $(this).attr('data-option_id');
    var optionText = $(this).attr('data-option_text');
    pointsData.push({
      top: thisTopPercent,
      left: thisLeftPercent,
      id: optionId,
      text:optionText
    });
  });
  return pointsData;
}

function showPoints(pointsArray) {
  for (var i = 0; i < pointsArray.length; i++) {
    var topPercent = pointsArray[i].top;
    var leftPercent = pointsArray[i].left;
    var question_id = pointsArray[i].question_id;
    var option_id = pointsArray[i].option_id;
    var label = pointsArray[i].label;
    // $('.js-point-img-container').append('<div style="top: ' + topPercent + '%; left: ' + leftPercent + '%;" class="img-point">\
    //         <input type="checkbox" id="point-id-' + i + '" name="points">\
    //         <label for="point-id-' + i + '"><span>Point</span></label>\
    //     </div>');
     $('.js-point-img-container').append('<div style="top: ' + topPercent + '%; left: ' + leftPercent + '%;"  class="img-point js-point-drag ui-draggable ui-draggable-handle" data-id="'+question_id+'" data-option_id="'+option_id+'" data-option_text="'+label+'"><div class="dragger-tooltip"><h>'+label+'</h></div><div class="delete-tooltip">X</div></div>');

  }
}
