@extends('physician.layouts.master')
@section('content')

<?php $success = false; ?>
@if (\Session::has('error'))
    <div class="alert alert-danger">
        {!! \Session::get('error') !!}
    </div>
@endif
@if (\Session::has('success'))
<?php $success = true; ?>
    <div class="alert alert-success">
        {!! \Session::get('success') !!}
    </div>
@endif

@if($success == true)
    <div class="row justify-content-center" style="display: none">
@else
    <div class="row justify-content-center">
@endif

 <div class="container">
    <center><h1></h1></center>
@if ($errors->any())
  <div class="alert alert-danger">
      <ul>
          @foreach ($errors->all() as $error)
              <li>{{ $error }}</li>
          @endforeach
      </ul>
  </div>
@endif
        <div class="page-content fade-in-up">
            <div class="row">
                <div class="col-md-12">
                    <div class="ibox">
                        <div class="ibox-head">
                            <div class="ibox-title">{{__('Change Password')}}</div>
                        </div>
                        <div class="ibox-body col-md-8">
                            <form  method="POST" action="{{route('reset_password')}}">
                                @csrf
                                  <div class="form-group mb-4">
                                        <label>{{ __('Old Password') }}</label>
                                         <input type="password" class="form-control{{ $errors->has('old_password') ? ' is-invalid' : '' }}" name="old_password" value="" data-validation1="required">
                                  </div> 

                                   <div class="form-group mb-4">
                                        <label>{{ __('Password') }}</label>
                                         <input type="password" class="form-control{{ $errors->has('password') ? ' is-invalid' : '' }}" data-validation1="required" name="new_password" data-validation1="length" data-validation-length1="min8" >
                                  </div> 

                                  <div class="form-group mb-4">
                                        <label>{{ __('Confirm Password') }}</label>
                                         <input type="password" class="form-control" name="confirm_password" data-validation1="required" data-validation="confirmation"  data-validation-confirm="password_confirm">
                                  </div> 

                                <div class="form-group row mb-0">
                                    <div class="col-md-6 offset-md-4">
                                        <input type="submit" class="btn btn-primary" name="btn-submit" value="Change Password">
                                    </div>
                                </div>
                            </form>
                        </div>
                    </div>
                </div>
            </div>  
        </div>
    </div>
</div>

<!-- JS FORM VALIDATION -->

<script src="//ajax.googleapis.com/ajax/libs/jquery/1.10.2/jquery.min.js"></script>
<script src="//cdnjs.cloudflare.com/ajax/libs/jquery-form-validator/2.3.26/jquery.form-validator.min.js"></script>
<script>
  $.validate({
    lang: 'en'
  });
</script>
@endsection

